/*
 * Decompiled with CFR 0.152.
 */
package groove.explore;

import groove.explore.AcceptorEnumerator;
import groove.explore.Exploration;
import groove.explore.GenerateProgressMonitor;
import groove.explore.StrategyEnumerator;
import groove.explore.StrategyValue;
import groove.explore.encode.Serialized;
import groove.explore.encode.TemplateList;
import groove.explore.result.Acceptor;
import groove.explore.strategy.Strategy;
import groove.explore.util.ExplorationStatistics;
import groove.grammar.Grammar;
import groove.grammar.aspect.GraphConverter;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.graph.Graph;
import groove.graph.plain.PlainGraph;
import groove.io.FileType;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatExporter;
import groove.io.external.PortException;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.util.CommandLineTool;
import groove.util.Groove;
import groove.util.StoreCommandLineOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class Generator
extends CommandLineTool {
    public static final String GC_LOG_NAME = "gc.log";
    public static final String ID_PREFIX = "gts";
    public static final String LOAD_ERROR = "Can't load graph grammar";
    public static final String USAGE_MESSAGE = "Usage: Generator [options] <grammar> [<start-graph-name> | <start-graphs-dir>]";
    public static final String GRAMMAR_NAME_VAR = "@";
    public static final char START_STATE_SEPARATOR = '@';
    private final TemplatedOption<Strategy> strategyOption;
    private final TemplatedOption<Acceptor> acceptorOption;
    private final ResultOption resultOption;
    private final ResultSaveOption resultSaveOption;
    private final ExportSimulationOption exportSimulationOption;
    private final ExportSimulationFlagsOption exportSimulationFlagsOption;
    private String id;
    private static GTS gts;
    private Exploration exploration;
    private ExplorationStatistics explorationStats;
    private String grammarLocation;
    private final List<String> startGraphs = new ArrayList<String>();
    private GrammarModel grammarModel;
    private Grammar grammar;

    public static void main(String[] args) {
        Generator.generate(args);
    }

    public static GTS generate(String[] args) {
        return new Generator(args).start();
    }

    public Generator(String ... args) {
        super(false, args);
        this.strategyOption = new TemplatedOption<Strategy>("s", "str", StrategyEnumerator.newInstance(StrategyValue.CONCRETE_STRATEGIES));
        this.acceptorOption = new TemplatedOption<Acceptor>("a", "acc", AcceptorEnumerator.newInstance());
        this.resultOption = new ResultOption();
        this.resultSaveOption = new ResultSaveOption();
        this.exportSimulationOption = new ExportSimulationOption();
        this.exportSimulationFlagsOption = new ExportSimulationFlagsOption();
        this.addOption(this.verbosityOption);
        this.addOption(this.logOption);
        this.addOption(this.strategyOption);
        this.addOption(this.acceptorOption);
        this.addOption(this.resultOption);
        this.addOption(this.exportSimulationOption);
        this.addOption(this.exportSimulationFlagsOption);
        this.addOption(this.outputOption);
        this.addOption(this.resultSaveOption);
        gts = null;
    }

    public GTS start() {
        this.processArguments();
        try {
            this.startLog();
            this.init();
            this.generate();
            this.report();
            this.exit();
            this.endLog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gts;
    }

    public void setGrammarLocation(String grammarLocation) {
        this.grammarLocation = grammarLocation;
    }

    private void addStartGraph(String startGraphName) {
        String name = startGraphName;
        if (name.startsWith(this.grammarLocation)) {
            name = name.substring(this.grammarLocation.length() + 1);
        }
        if (name.endsWith(".gst")) {
            name = name.substring(0, name.length() - 4);
        }
        this.startGraphs.add(name);
    }

    @Override
    protected String getId() {
        if (this.id == null) {
            this.id = this.computeId();
        }
        return this.id;
    }

    protected String computeId() {
        return "gts#" + this.getGrammarName() + "#" + super.getId();
    }

    public GTS getGTS() {
        if (gts == null) {
            gts = new GTS(this.getGrammar());
        }
        return gts;
    }

    public GrammarModel getGrammarModel() {
        if (this.grammarModel == null) {
            URL url;
            Observer loadObserver = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    if (Generator.this.getVerbosity() > 0) {
                        if (arg instanceof String) {
                            System.out.printf("%s .", arg);
                        } else if (arg == null) {
                            System.out.println(" done");
                        } else {
                            System.out.print(".");
                        }
                    }
                }
            };
            File f = new File(FileType.GRAMMAR_FILTER.addExtension(this.grammarLocation));
            try {
                url = f.exists() ? Groove.toURL(f) : new URL(this.grammarLocation);
            }
            catch (MalformedURLException e) {
                this.printError("Can't load grammar: " + e.getMessage(), false);
                return null;
            }
            try {
                ArrayList<String> startGraphNames = new ArrayList<String>(this.startGraphs);
                if (this.startGraphs.isEmpty()) {
                    startGraphNames.add("start");
                }
                this.grammarModel = GrammarModel.newInstance(url);
                this.grammarModel.setLocalActiveNames(ResourceKind.HOST, startGraphNames);
                this.grammarModel.getStore().addObserver(loadObserver);
            }
            catch (IOException exc) {
                this.printError("Can't load grammar: " + exc.getMessage(), false);
            }
        }
        return this.grammarModel;
    }

    public Grammar getGrammar() {
        if (this.grammar == null) {
            try {
                this.grammar = this.getGrammarModel().toGrammar();
                this.grammar.setFixed();
            }
            catch (FormatException exc) {
                this.printError("Grammar format error: " + exc.getMessage(), false);
            }
        }
        return this.grammar;
    }

    @Override
    public void processArguments() {
        super.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            this.setGrammarLocation(argsList.remove(0));
        }
        while (argsList.size() > 0) {
            String arg = argsList.remove(0);
            if (arg.startsWith("-")) {
                if (argsList.size() <= 0) continue;
                argsList.remove(0);
                continue;
            }
            this.addStartGraph(arg);
        }
        if (this.grammarLocation == null) {
            this.printError("No grammar location specified", true);
        }
    }

    protected Exploration getExploration() {
        if (this.exploration == null) {
            this.exploration = this.computeExploration();
        }
        return this.exploration;
    }

    protected Exploration computeExploration() {
        Exploration result = this.getGrammarModel().getDefaultExploration();
        if (result == null) {
            result = new Exploration();
        }
        Serialized strategy = this.isOptionActive(this.strategyOption) ? (Serialized)this.strategyOption.getValue() : result.getStrategy();
        Serialized acceptor = this.isOptionActive(this.acceptorOption) ? (Serialized)this.acceptorOption.getValue() : result.getAcceptor();
        int nrResults = this.isOptionActive(this.resultOption) ? (Integer)this.resultOption.getValue() : 0;
        return new Exploration(strategy, acceptor, nrResults);
    }

    protected void init() {
        this.explorationStats = new ExplorationStatistics(this.getGTS());
        this.explorationStats.configureForGenerator(this.getVerbosity());
    }

    protected void generate() {
        if (this.getVerbosity() > 0) {
            this.println("Grammar:\t" + this.grammarLocation);
            this.println("Start graph:\t" + (this.startGraphs == null ? "default" : this.startGraphs));
            this.println("Exploration:\t" + this.getExploration().getIdentifier());
            this.println("Timestamp:\t" + this.invocationTime);
            this.print("\nProgress:\t");
            this.getGTS().addLTSListener(new GenerateProgressMonitor());
        }
        this.explorationStats.start();
        try {
            this.getExploration().play(this.getGTS(), null);
        }
        catch (FormatException e) {
            this.printError("The specified exploration is not valid for the loaded grammar.\n" + e.getMessage(), false);
        }
        this.explorationStats.stop();
    }

    protected void exportSimulation() {
        boolean e = this.isOptionActive(this.exportSimulationOption);
        boolean ef = this.isOptionActive(this.exportSimulationFlagsOption);
        String path = e ? (String)this.exportSimulationOption.getValue() : ".";
        ExportSimulationFlags flags = ef ? (ExportSimulationFlags)this.exportSimulationFlagsOption.getValue() : new ExportSimulationFlags();
        PlainGraph lts = this.getGTS().toPlainGraph(flags.labelFinalStates, flags.labelStartState, flags.labelOpenStates, flags.exportStateNames);
        try {
            if (this.isOptionActive(this.outputOption)) {
                String outFilename = this.getOutputFileName();
                String ltsFilename = outFilename == null ? String.valueOf(path) + "/gts" + FileType.GXL.getExtension() : String.valueOf(path) + "/" + outFilename;
                File ltsFile = new File(ltsFilename);
                Format gtsFormat = Exporter.getAcceptingFormat(lts, ltsFile);
                if (gtsFormat != null) {
                    try {
                        ((FormatExporter)gtsFormat.getFormatter()).doExport(ltsFile, gtsFormat, new Exporter.Exportable(lts));
                    }
                    catch (PortException e1) {
                        throw new IOException(e1);
                    }
                } else {
                    Groove.saveGraph((Graph)lts, ltsFile);
                }
            }
            if (this.isOptionActive(this.resultSaveOption)) {
                ResultSave rs = (ResultSave)this.resultSaveOption.getValue();
                Collection<GraphState> export = this.getExploration().getLastResult().getValue();
                for (GraphState state : export) {
                    String stateFilename = String.valueOf(path) + "/" + rs.prefix + state.getNumber() + rs.suffix + rs.type.getExtension();
                    File stateFile = new File(stateFilename);
                    Format stateFormat = Exporter.getAcceptingFormat(state.getGraph(), stateFile);
                    if (stateFormat != null) {
                        try {
                            ((FormatExporter)stateFormat.getFormatter()).doExport(stateFile, stateFormat, new Exporter.Exportable(state.getGraph()));
                            continue;
                        }
                        catch (PortException e1) {
                            throw new IOException(e1);
                        }
                    }
                    Groove.saveGraph((Graph)GraphConverter.toAspect(state.getGraph()), stateFile);
                }
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    protected void report() {
        File gcLogFile;
        if (this.getVerbosity() > 0) {
            this.println();
            this.println();
            String report = this.explorationStats.getReport();
            if (report.length() > 0) {
                this.println(report);
            }
        }
        this.println(this.getExploration().getLastMessage());
        if (this.isLogging() && (gcLogFile = new File(GC_LOG_NAME)).exists()) {
            try {
                BufferedReader gcLog = new BufferedReader(new FileReader(gcLogFile));
                ArrayList<String> gcList = new ArrayList<String>();
                String nextLine = gcLog.readLine();
                while (nextLine != null) {
                    gcList.add(nextLine);
                    nextLine = gcLog.readLine();
                }
                int i = 1;
                while (i < gcList.size() - 2) {
                    this.getLogWriter().println((String)gcList.get(i));
                    ++i;
                }
                gcLog.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error while opening GC log");
            }
            catch (IOException iOException) {
                System.err.println("Error while reading from GC log");
            }
        }
        this.exportSimulation();
    }

    public long getRunningTime() {
        return this.explorationStats.getRunningTime();
    }

    protected void exit() {
    }

    @Override
    protected String getOutputFileName() {
        String result = super.getOutputFileName();
        if (result != null) {
            String grammarNameRegExpr = GRAMMAR_NAME_VAR;
            result = result.replaceAll(grammarNameRegExpr, this.getGrammarName());
        }
        return result;
    }

    protected String getGrammarName() {
        StringBuilder result = new StringBuilder(new File(FileType.GRAMMAR_FILTER.stripExtension(this.grammarLocation)).getName());
        if (this.startGraphs != null) {
            result.append('@');
            result.append(this.startGraphs);
        }
        return result.toString();
    }

    @Override
    protected String getLogFileName() {
        return this.getId();
    }

    @Override
    protected String getUsageMessage() {
        return USAGE_MESSAGE;
    }

    private static class ExportSimulationFlags {
        public boolean labelStartState = false;
        public boolean labelFinalStates = false;
        public boolean labelOpenStates = false;
        public boolean exportStateNames = false;

        private ExportSimulationFlags() {
        }
    }

    protected static class ExportSimulationFlagsOption
    extends StoreCommandLineOption<ExportSimulationFlags> {
        public ExportSimulationFlagsOption() {
            super("ef", "flags");
        }

        @Override
        public String[] getDescription() {
            String[] desc = new String[]{"Flags for the export simulation option. Legal flags are:", "  s - label start state", "  f - label final states", "  o - label open states", "  n - export state names"};
            return desc;
        }

        @Override
        public ExportSimulationFlags parseParameter(String parameter) {
            ExportSimulationFlags result = new ExportSimulationFlags();
            int i = 0;
            while (i < parameter.length()) {
                switch (parameter.charAt(i)) {
                    case 's': {
                        result.labelStartState = true;
                        break;
                    }
                    case 'f': {
                        result.labelFinalStates = true;
                        break;
                    }
                    case 'o': {
                        result.labelOpenStates = true;
                        break;
                    }
                    case 'n': {
                        result.exportStateNames = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("'" + parameter.charAt(i) + "' is not a valid export simulation flag.");
                    }
                }
                ++i;
            }
            return result;
        }
    }

    protected static class ExportSimulationOption
    extends StoreCommandLineOption<String> {
        public ExportSimulationOption() {
            super("e", "path");
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Export the simulation to the specified path (default is grammar path)"};
        }

        @Override
        public String parseParameter(String parameter) {
            return parameter;
        }
    }

    public static class ResultOption
    extends StoreCommandLineOption<Integer> {
        public ResultOption() {
            super("r", "num");
        }

        @Override
        public String[] getDescription() {
            return new String[]{"The number of accepted exploration results (default is infinite)"};
        }

        @Override
        public Integer parseParameter(String parameter) {
            try {
                Integer result = Integer.parseInt(parameter);
                if (result <= 0) {
                    throw new IllegalArgumentException("'" + parameter + "' is not a valid positive number.");
                }
                return result;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("'" + parameter + "' is not a valid positive number.");
            }
        }
    }

    static class ResultSave {
        String prefix = "";
        String suffix = "";
        FileType type = FileType.GXL;

        ResultSave() {
        }
    }

    protected static class ResultSaveOption
    extends StoreCommandLineOption<ResultSave> {
        public ResultSaveOption() {
            super("f", "a#b.e");
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Save all result states using '" + this.getParameterName() + "' with # being state number.", "Saving format is determined by extension 'e' (default is GXL)."};
        }

        @Override
        public ResultSave parseParameter(String parameter) {
            ResultSave result = new ResultSave();
            try {
                String[] s = parameter.split("#");
                result.prefix = s[0];
                String[] t = s[1].split("\\.");
                result.suffix = t[0];
                for (FileType type : FileType.layoutless) {
                    if (!t[1].equals(type.getExtensionName())) continue;
                    result.type = type;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            return result;
        }
    }

    public static class TemplatedOption<A>
    extends StoreCommandLineOption<Serialized> {
        private final TemplateList<A> enumerator;

        public TemplatedOption(String name, String parameterName, TemplateList<A> enumerator) {
            super(name, parameterName);
            this.enumerator = enumerator;
        }

        @Override
        public String[] getDescription() {
            String[] lines = this.enumerator.describeCommandlineGrammar();
            String[] desc = new String[lines.length + 1];
            desc[0] = "The " + this.enumerator.getTypeIdentifier() + ". Legal values for '" + this.getParameterName() + "' are:";
            desc[1] = "  " + lines[0] + " (default value)";
            int i = 1;
            while (i < lines.length) {
                desc[i + 1] = "  " + lines[i];
                ++i;
            }
            return desc;
        }

        @Override
        public Serialized parseParameter(String parameter) {
            Serialized result = this.enumerator.parseCommandline(parameter);
            if (result == null) {
                throw new IllegalArgumentException("Unable to parse " + this.getName() + " argument '" + parameter + "'.");
            }
            return result;
        }
    }
}

