/*
 * Decompiled with CFR 0.152.
 */
package groove.explore;

import groove.explore.Exploration;
import groove.explore.ParsableValue;
import groove.explore.encode.EncodedEnabledRule;
import groove.explore.encode.EncodedRuleFormula;
import groove.explore.encode.EncodedRuleMode;
import groove.explore.encode.EncodedType;
import groove.explore.encode.Serialized;
import groove.explore.encode.Template;
import groove.explore.prettyparse.PAll;
import groove.explore.prettyparse.PIdentifier;
import groove.explore.prettyparse.POptional;
import groove.explore.prettyparse.PSequence;
import groove.explore.prettyparse.SerializedParser;
import groove.explore.result.Acceptor;
import groove.explore.result.AnyStateAcceptor;
import groove.explore.result.CycleAcceptor;
import groove.explore.result.FinalStateAcceptor;
import groove.explore.result.NoStateAcceptor;
import groove.explore.result.Predicate;
import groove.explore.result.PredicateAcceptor;
import groove.grammar.Rule;
import groove.grammar.model.GrammarModel;
import groove.lts.GraphState;

public enum AcceptorValue implements ParsableValue
{
    FINAL("final", "Final States", "This acceptor succeeds when a state is added to the LTS that is <I>final</I>. A state is final when no modifying rule isapplicable on it."),
    INVARIANT("inv", "Check Invariant", "This acceptor succeeds when a state is reached in which the indicated rule is applicable. Note that this is detected <I>before</I> the rule has been applied.<BR> This acceptor ignores rule priorities."),
    RULE("ruleapp", "Rule Application", "This acceptor succeeds when a transition of the indicated rule is added to the LTS. Note that this is detected <I>after</I> the rule has been applied (which means that rule priorities are taken into account)."),
    FORMULA("formula", "Rule Formula", "This acceptor is a variant of Check Invariant that succeeds when a state is reached in which an arbitrary rule <i>formula</i> is applicable."),
    ANY("any", "Any State", "This acceptor succeeds whenever a state is added to the LTS."),
    CYCLE("cycle", "Cycles", "This acceptor listens to pairs of graph states and B\u00fcchi states,and succeeds when a pair is added that lies on a cycle with anaccepting B\u00fcchi state. Should only be used in conjunction with LTL model checking."),
    NONE("none", "No State", "This acceptor always fails whenever a state is added to the LTS.");

    private final String keyword;
    private final String name;
    private final String description;

    private AcceptorValue(String keyword, String name, String description) {
        this.keyword = keyword;
        this.name = name;
        this.description = description;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Serialized toSerialized() {
        return new Serialized(this.getKeyword());
    }

    @Override
    public boolean isDevelopment() {
        return false;
    }

    @Override
    public boolean isDefault(GrammarModel grammar) {
        Exploration exploration = grammar.getDefaultExploration();
        return exploration == null ? this == FINAL : exploration.getAcceptor().getKeyword().equals(this.getKeyword());
    }

    public Template<Acceptor> getTemplate() {
        switch (this) {
            case ANY: {
                return new MyTemplate0(){

                    @Override
                    public Acceptor create() {
                        return new AnyStateAcceptor();
                    }
                };
            }
            case CYCLE: {
                return new MyTemplate0(){

                    @Override
                    public Acceptor create() {
                        return new CycleAcceptor();
                    }
                };
            }
            case FINAL: {
                return new MyTemplate0(){

                    @Override
                    public Acceptor create() {
                        return new FinalStateAcceptor();
                    }
                };
            }
            case FORMULA: {
                return new MyTemplate1<Predicate<GraphState>>((SerializedParser)new PAll("formula"), "formula", (EncodedType)new EncodedRuleFormula()){

                    @Override
                    public Acceptor create(Predicate<GraphState> predicate) {
                        return new PredicateAcceptor(predicate);
                    }
                };
            }
            case INVARIANT: {
                PSequence parser = new PSequence(new POptional("!", "mode", "Negative", "Positive"), new PIdentifier("rule"));
                return new MyTemplate2<Rule, Boolean>((SerializedParser)parser, "rule", (EncodedType)new EncodedEnabledRule(), "mode", (EncodedType)new EncodedRuleMode()){

                    @Override
                    public Acceptor create(Rule rule, Boolean mode) {
                        Predicate P = new Predicate.RuleApplicable(rule);
                        if (!mode.booleanValue()) {
                            P = new Predicate.Not<GraphState>(P);
                        }
                        return new PredicateAcceptor(P);
                    }
                };
            }
            case NONE: {
                return new MyTemplate0(){

                    @Override
                    public Acceptor create() {
                        return new NoStateAcceptor();
                    }
                };
            }
            case RULE: {
                return new MyTemplate1<Rule>((SerializedParser)new PIdentifier("rule"), "rule", (EncodedType)new EncodedEnabledRule()){

                    @Override
                    public Acceptor create(Rule rule) {
                        return new PredicateAcceptor(new Predicate.RuleApplied(rule));
                    }
                };
            }
        }
        throw new IllegalStateException();
    }

    private abstract class MyTemplate0
    extends Template.Template0<Acceptor> {
        public MyTemplate0() {
            super(AcceptorValue.this);
        }
    }

    private abstract class MyTemplate1<T1>
    extends Template.Template1<Acceptor, T1> {
        public MyTemplate1(SerializedParser parser, String name, EncodedType<T1, String> type) {
            super((ParsableValue)AcceptorValue.this, parser, name, type);
        }
    }

    private abstract class MyTemplate2<T1, T2>
    extends Template.Template2<Acceptor, T1, T2> {
        public MyTemplate2(SerializedParser parser, String name1, EncodedType<T1, String> type1, String name2, EncodedType<T2, String> type2) {
            super((ParsableValue)AcceptorValue.this, parser, name1, type1, name2, type2);
        }
    }
}

