/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.algebra.Algebra;
import groove.algebra.Algebras;
import groove.control.CtrlType;
import groove.control.CtrlVar;
import groove.grammar.rule.RuleNode;

public abstract class CtrlPar {
    public static final String DONT_CARE = "_";
    public static final String OUT_PREFIX = "out";

    public abstract boolean isInOnly();

    public abstract boolean isOutOnly();

    public abstract boolean isDontCare();

    public abstract CtrlType getType();

    public static class Const
    extends CtrlPar {
        private final Algebra<?> algebra;
        private final Object value;
        private final CtrlType type;

        public Const(Algebra<?> algebra, String repr) {
            this.algebra = algebra;
            this.value = algebra.getValueFromSymbol(repr);
            this.type = CtrlType.getDataType(Algebras.getSignatureFor(repr));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Const)) {
                return false;
            }
            Const other = (Const)obj;
            return this.getValue().equals(other.getValue());
        }

        public Algebra<?> getAlgebra() {
            return this.algebra;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public CtrlType getType() {
            return this.type;
        }

        public int hashCode() {
            return this.getValue().hashCode();
        }

        @Override
        public boolean isDontCare() {
            return false;
        }

        @Override
        public boolean isInOnly() {
            return true;
        }

        @Override
        public boolean isOutOnly() {
            return false;
        }

        public String toString() {
            return this.algebra.getSymbol(this.value);
        }
    }

    public static class Var
    extends CtrlPar {
        private RuleNode ruleNode;
        private boolean creator;
        private final CtrlVar var;
        private final boolean inOnly;
        private final boolean outOnly;

        public Var(CtrlVar var) {
            this.var = var;
            this.inOnly = false;
            this.outOnly = false;
        }

        public Var(CtrlVar var, boolean inOnly) {
            this.var = var;
            this.inOnly = inOnly;
            this.outOnly = !inOnly;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Var)) {
                return false;
            }
            Var other = (Var)obj;
            return this.isInOnly() == other.isInOnly() && this.getVar().equals(other.getVar());
        }

        @Override
        public CtrlType getType() {
            return this.getVar().getType();
        }

        public CtrlVar getVar() {
            return this.var;
        }

        public int hashCode() {
            int result = this.isInOnly() ? 0 : (this.isOutOnly() ? 1 : 2);
            return result += this.getVar().hashCode();
        }

        @Override
        public boolean isDontCare() {
            return !this.inOnly && !this.outOnly;
        }

        @Override
        public boolean isInOnly() {
            return this.inOnly;
        }

        @Override
        public boolean isOutOnly() {
            return this.outOnly;
        }

        public String toString() {
            String result = this.isOutOnly() ? "out " : "";
            result = String.valueOf(result) + this.getVar().toString();
            return result;
        }

        public boolean compatibleWith(CtrlPar arg) {
            CtrlType argType = arg.getType();
            if (argType != null && !this.getType().equals((Object)argType)) {
                return false;
            }
            if (this.isDontCare()) {
                return true;
            }
            if (this.isInOnly()) {
                return arg.isInOnly();
            }
            assert (this.isOutOnly());
            return !arg.isInOnly();
        }

        public RuleNode getRuleNode() {
            return this.ruleNode;
        }

        public void setRuleNode(RuleNode ruleNode, boolean creator) {
            this.ruleNode = ruleNode;
            this.creator = creator;
        }

        public final boolean isCreator() {
            return this.creator;
        }
    }

    public static class Wild
    extends CtrlPar {
        public boolean equals(Object obj) {
            return obj instanceof Wild;
        }

        @Override
        public CtrlType getType() {
            return null;
        }

        public int hashCode() {
            return Wild.class.hashCode();
        }

        @Override
        public boolean isDontCare() {
            return true;
        }

        @Override
        public boolean isInOnly() {
            return false;
        }

        @Override
        public boolean isOutOnly() {
            return false;
        }

        public String toString() {
            return CtrlPar.DONT_CARE;
        }
    }
}

