/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.RegExpr;
import groove.automaton.RegExprCalculator;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.rule.LabelVar;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegExprTyper
implements RegExprCalculator<Result> {
    private final Map<LabelVar, Set<? extends TypeElement>> varTyping;
    private final TypeGraph typeGraph;

    public RegExprTyper(TypeGraph typeGraph, Map<LabelVar, Set<? extends TypeElement>> varTyping) {
        this.typeGraph = typeGraph;
        this.varTyping = varTyping;
    }

    @Override
    public Result computeNeg(RegExpr.Neg expr, Result arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Result computeStar(RegExpr.Star expr, Result arg) {
        Result result = new Result().getUnion(arg).getClosure();
        if (!arg.isEmpty() && result.isEmpty()) {
            result.addError("%s cannot be typed", expr);
        }
        return result;
    }

    @Override
    public Result computePlus(RegExpr.Plus expr, Result arg) {
        Result result = arg.getClosure();
        if (!arg.isEmpty() && result.isEmpty()) {
            result.addError("%s cannot be typed", expr);
        }
        return result;
    }

    @Override
    public Result computeInv(RegExpr.Inv expr, Result arg) {
        return arg.getInverse();
    }

    @Override
    public Result computeSeq(RegExpr.Seq expr, List<Result> argList) {
        Result result = argList.get(0);
        if (!result.isEmpty()) {
            int i = 1;
            while (i < argList.size()) {
                result = result.getThen(argList.get(i));
                ++i;
            }
            if (result.isEmpty()) {
                result.addError("%s cannot be typed", expr);
            }
        }
        return result;
    }

    @Override
    public Result computeChoice(RegExpr.Choice expr, List<Result> argList) {
        Result result = argList.get(0);
        int i = 1;
        while (i < argList.size()) {
            result = result.getUnion(argList.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public Result computeAtom(RegExpr.Atom expr) {
        Result result = new Result();
        TypeLabel typeLabel = expr.toTypeLabel();
        if (this.typeGraph.isNodeType(typeLabel)) {
            for (TypeNode subType : this.typeGraph.getNode(typeLabel).getSubtypes()) {
                result.add(subType, subType);
            }
        } else {
            for (TypeEdge edgeType : this.typeGraph.edgeSet(typeLabel)) {
                Set<TypeNode> targetTypes = ((TypeNode)edgeType.target()).getSubtypes();
                for (TypeNode sourceType : ((TypeNode)edgeType.source()).getSubtypes()) {
                    result.add(sourceType, targetTypes);
                }
            }
        }
        if (result.isEmpty()) {
            result.addError("%s cannot be typed", expr);
        }
        return result;
    }

    @Override
    public Result computeSharp(RegExpr.Sharp expr) {
        Result result = new Result();
        TypeLabel typeLabel = expr.getSharpLabel();
        if (this.typeGraph.isNodeType(typeLabel)) {
            for (TypeNode subType : this.typeGraph.getNode(typeLabel).getSubtypes()) {
                result.add(subType, subType);
            }
        } else {
            for (TypeEdge edgeType : this.typeGraph.edgeSet(typeLabel)) {
                result.add((TypeNode)edgeType.source(), (TypeNode)edgeType.target());
            }
        }
        if (result.isEmpty()) {
            result.addError("%s cannot be typed", expr);
        }
        return result;
    }

    @Override
    public Result computeWildcard(RegExpr.Wildcard expr) {
        Result result = this.typeGraph.isNodeType(expr.getKind()) ? this.computeNodeWildcard(expr) : this.computeEdgeWildcard(expr);
        if (result.isEmpty()) {
            result.addError("%s cannot be typed", expr);
        }
        return result;
    }

    private Result computeNodeWildcard(RegExpr.Wildcard expr) {
        Result result = new Result();
        LabelVar var = expr.getWildcardId();
        HashSet candidates = new HashSet();
        if (var.hasName()) {
            candidates.addAll((Collection)this.varTyping.get(var));
        } else {
            candidates.addAll(this.typeGraph.nodeSet());
        }
        TypeGuard guard = expr.getWildcardGuard();
        for (TypeNode typeNode : (Set)guard.filter(candidates)) {
            result.add(typeNode, typeNode);
        }
        return result;
    }

    private Result computeEdgeWildcard(RegExpr.Wildcard expr) {
        Result result = new Result();
        LabelVar var = expr.getWildcardId();
        HashSet candidates = new HashSet();
        if (var.hasName()) {
            candidates.addAll(this.varTyping.get(var));
        } else {
            candidates.addAll(this.typeGraph.edgeSet());
        }
        TypeGuard guard = expr.getWildcardGuard();
        for (TypeEdge typeEdge : (Set)guard.filter(candidates)) {
            Set<TypeNode> targetTypes = ((TypeNode)typeEdge.target()).getSubtypes();
            for (TypeNode sourceType : ((TypeNode)typeEdge.source()).getSubtypes()) {
                if (expr.getKind() == EdgeRole.BINARY) {
                    result.add(sourceType, targetTypes);
                    continue;
                }
                result.add(sourceType, sourceType);
            }
        }
        return result;
    }

    @Override
    public Result computeEmpty(RegExpr.Empty expr) {
        Result result = new Result();
        for (TypeNode node : this.typeGraph.nodeSet()) {
            if (node.getSupertypes().size() != 1) continue;
            for (TypeNode node1 : node.getSubtypes()) {
                for (TypeNode node2 : node.getSubtypes()) {
                    result.add(node1, node2);
                }
            }
        }
        return result;
    }

    public static class Result {
        private int size = 0;
        private final Map<TypeNode, Set<TypeNode>> map = new HashMap<TypeNode, Set<TypeNode>>();
        private final FormatErrorSet errors = new FormatErrorSet();

        public int getSize() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set<TypeNode> getAll(TypeNode left) {
            return this.map.get(left);
        }

        public Map<TypeNode, Set<TypeNode>> getMap() {
            return this.map;
        }

        public boolean add(TypeNode left, TypeNode right) {
            boolean result;
            Set<TypeNode> current = this.map.get(left);
            if (current == null) {
                current = new HashSet<TypeNode>();
                this.map.put(left, current);
            }
            if (result = current.add(right)) {
                ++this.size;
            }
            return result;
        }

        public boolean add(TypeNode left, Collection<? extends TypeNode> right) {
            Set<TypeNode> current = this.map.get(left);
            if (current == null) {
                current = new HashSet<TypeNode>();
                this.map.put(left, current);
            }
            int currentSize = current.size();
            current.addAll(right);
            this.size += current.size() - currentSize;
            return current.size() > currentSize;
        }

        public Result getInverse() {
            Result result = new Result();
            for (Map.Entry<TypeNode, Set<TypeNode>> entry : this.map.entrySet()) {
                TypeNode left = entry.getKey();
                for (TypeNode right : entry.getValue()) {
                    result.add(right, left);
                }
            }
            result.addErrors(this.getErrors());
            return result;
        }

        public Result getThen(Result other) {
            Result result = new Result();
            for (Map.Entry<TypeNode, Set<TypeNode>> entry : this.map.entrySet()) {
                HashSet<TypeNode> allRight = new HashSet<TypeNode>();
                for (TypeNode right : entry.getValue()) {
                    Set<TypeNode> otherRight = other.getAll(right);
                    if (otherRight == null) continue;
                    allRight.addAll(otherRight);
                }
                if (allRight.isEmpty()) continue;
                result.add(entry.getKey(), allRight);
            }
            result.addErrors(this.getErrors());
            result.addErrors(other.getErrors());
            return result;
        }

        public Result getUnion(Result other) {
            Result result = new Result();
            this.copyTo(result);
            other.copyTo(result);
            return result;
        }

        public Result getClosure() {
            Result result = this;
            int oldSize = 0;
            int newSize = result.getSize();
            while (newSize > oldSize) {
                result = result.getThen(this);
                result.union(this);
                oldSize = newSize;
                newSize = result.getSize();
            }
            return result;
        }

        private boolean union(Result other) {
            return other.copyTo(this);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            return this.map.equals(other.map);
        }

        public String toString() {
            return this.map.toString();
        }

        public void addError(String message, Object ... args) {
            this.errors.add(message, args);
        }

        private void addErrors(Collection<FormatError> errors) {
            this.errors.addAll(errors);
        }

        public FormatErrorSet getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return !this.getErrors().isEmpty();
        }

        private boolean copyTo(Result other) {
            boolean result = false;
            for (Map.Entry<TypeNode, Set<TypeNode>> entry : this.map.entrySet()) {
                result |= other.add(entry.getKey(), (Collection<? extends TypeNode>)entry.getValue());
            }
            other.addErrors(this.getErrors());
            return result;
        }
    }
}

