/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.SimpleMorphism;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.plain.PlainLabel;

public final class RuleEdge
extends AbstractPatternEdge<RuleNode> {
    public static final String PREFIX = "s";
    private final TypeEdge type;

    public RuleEdge(int nr, RuleNode source, TypeEdge type, RuleNode target) {
        super(nr, source, (PlainLabel)type.label(), target);
        this.type = type;
    }

    @Override
    public boolean setFixed() {
        assert (this.type.isFixed());
        return false;
    }

    @Override
    public boolean isFixed() {
        return this.type.isFixed();
    }

    @Override
    protected String getToStringPrefix() {
        return PREFIX;
    }

    @Override
    public String toString() {
        return "r" + ((RuleNode)this.source).getNumber() + "--" + this.getPrintableLabel() + "-->" + "r" + ((RuleNode)this.target).getNumber();
    }

    @Override
    public SimpleMorphism getMorphism() {
        return this.getType().getMorphism();
    }

    @Override
    public String getPrintableLabel() {
        return PREFIX + this.getNumber() + ":" + this.type.getIdStr();
    }

    public TypeEdge getType() {
        return this.type;
    }
}

