/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.Node;
import groove.util.Duo;
import groove.util.Pair;

public final class PatternGraphRuleApplication {
    private final PatternGraph pGraph;
    private final PatternRule pRule;
    private final Match match;

    public PatternGraphRuleApplication(PatternGraph pGraph, Match match) {
        this.pGraph = pGraph;
        this.match = match;
        this.pRule = match.getRule();
    }

    public void transformWithClosureRule() {
        assert (this.pRule.isClosure());
        RuleNode rNode = this.pRule.getCreatorNodes()[0];
        this.createPattern(this.pGraph, rNode, true);
    }

    public PatternGraph transform(boolean inPlace) {
        if (!this.pRule.isModifying()) {
            return this.pGraph;
        }
        if (inPlace) {
            return this.transform(this.pGraph);
        }
        return this.transform(this.pGraph.clone());
    }

    private PatternGraph transform(PatternGraph host) {
        assert (!this.pRule.isClosure());
        this.erasePatterns(host);
        this.createPatterns(host);
        this.close(host);
        return host;
    }

    private void erasePatterns(PatternGraph host) {
        RuleNode[] ruleNodeArray = this.pRule.getEraserNodes();
        int n = ruleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleNode rNode = ruleNodeArray[n2];
            host.deletePattern((PatternNode)this.match.getNode(rNode));
            ++n2;
        }
    }

    private void createPatterns(PatternGraph host) {
        RuleNode rNode;
        RuleNode[] ruleNodeArray = this.pRule.getCreatorNodes();
        int n = ruleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            rNode = ruleNodeArray[n2];
            if (rNode.isNodePattern()) {
                PatternNode newNode = host.addNodePattern(rNode.getType());
                this.match.putNode(rNode, newNode);
            }
            ++n2;
        }
        ruleNodeArray = this.pRule.getCreatorNodes();
        n = ruleNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            rNode = ruleNodeArray[n2];
            if (rNode.isEdgePattern()) {
                this.createPattern(host, rNode, false);
            }
            ++n2;
        }
    }

    private void createPattern(PatternGraph host, RuleNode rNode, boolean closure) {
        Duo inEdges = this.pRule.rhs().getIncomingEdges(rNode);
        RuleEdge r1 = (RuleEdge)inEdges.one();
        RuleEdge r2 = (RuleEdge)inEdges.two();
        TypeEdge m1 = r1.getType();
        TypeEdge m2 = r2.getType();
        PatternNode p1 = (PatternNode)this.match.getNode((Node)r1.source());
        PatternNode p2 = (PatternNode)this.match.getNode((Node)r2.source());
        if (closure) {
            host.closePattern(m1, m2, p1, p2);
        } else {
            Pair<PatternNode, Duo<PatternEdge>> pair = host.addEdgePattern(m1, m2, p1, p2);
            PatternNode newNode = pair.one();
            PatternEdge d1 = (PatternEdge)pair.two().one();
            PatternEdge d2 = (PatternEdge)pair.two().two();
            this.match.putNode(rNode, newNode);
            this.match.putEdge(r1, d1);
            this.match.putEdge(r2, d2);
        }
    }

    private void close(PatternGraph host) {
        this.pRule.getTypeGraph().close(host);
    }
}

