/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape.iso;

import groove.abstraction.Multiplicity;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Morphism;
import groove.graph.Node;
import groove.graph.iso.IsoChecker;
import groove.util.Pair;
import java.util.Map;

public final class PatternShapeIsoChecker
extends IsoChecker {
    private static final int NON_ISO = 0;
    private static final int DOM_EQUALS_COD = 1;
    private static final int DOM_SUBSUMES_COD = 2;
    private static final int COD_SUBSUMES_DOM = 4;
    private static PatternShapeIsoChecker instance;

    public static PatternShapeIsoChecker getInstance() {
        if (instance == null) {
            instance = new PatternShapeIsoChecker();
        }
        return instance;
    }

    private PatternShapeIsoChecker() {
        super(true);
    }

    private boolean isDomEqualsCod(int result) {
        return (result & 1) == 1;
    }

    private boolean isDomSubsumesCod(int result) {
        return (result & 2) == 2;
    }

    public boolean isCodSubsumesDom(int result) {
        return (result & 4) == 4;
    }

    public boolean isDomStrictlyLargerThanCod(int result) {
        return this.isDomSubsumesCod(result) && !this.isDomEqualsCod(result);
    }

    public boolean areEqual(int result) {
        return this.isDomEqualsCod(result) || this.isCodSubsumesDom(result);
    }

    public boolean areIsomorphic(PatternShape dom, PatternShape cod) {
        int result = this.compareShapes(dom, cod).one();
        return this.areEqual(result);
    }

    public Pair<Integer, Morphism<PatternNode, PatternEdge>> compareShapes(PatternShape dom, PatternShape cod) {
        Pair<Integer, Object> result = new Pair<Integer, Object>(0, null);
        if (!this.passBasicChecks(dom, cod)) {
            return result;
        }
        IsoChecker.IsoCheckerState state = new IsoChecker.IsoCheckerState(this);
        Morphism<PatternNode, PatternEdge> morphism = this.getIsomorphism(dom, cod, state);
        int comparison = 0;
        while (morphism != null) {
            comparison = this.checkIsomorphism(dom, cod, morphism);
            if (comparison != 0) {
                result = new Pair<Integer, Morphism<PatternNode, PatternEdge>>(comparison, morphism);
                break;
            }
            morphism = this.getIsomorphism(dom, cod, state);
            if (morphism == null || state.isPlanEmpty()) break;
        }
        return result;
    }

    private int checkIsomorphism(PatternShape dom, PatternShape cod, Morphism<PatternNode, PatternEdge> morphism) {
        int result = 7;
        Map<PatternNode, Multiplicity> domNodeMultMap = dom.getNodeMultMap();
        Map<PatternNode, Multiplicity> codNodeMultMap = cod.getNodeMultMap();
        for (Map.Entry<PatternNode, PatternNode> nodeEntry : morphism.nodeMap().entrySet()) {
            Multiplicity codNMult;
            PatternNode domNode = nodeEntry.getKey();
            PatternNode codNode = nodeEntry.getValue();
            Multiplicity domNMult = domNodeMultMap.get(domNode);
            int comparison = this.compareMultiplicities(domNMult, codNMult = codNodeMultMap.get(codNode));
            if ((result = this.updateResult(result, comparison)) != 0) continue;
            return 0;
        }
        Map<PatternEdge, Multiplicity> domEdgeMultMap = dom.getEdgeMultMap();
        Map<PatternEdge, Multiplicity> codEdgeMultMap = cod.getEdgeMultMap();
        for (Map.Entry<PatternEdge, PatternEdge> edgeEntry : morphism.edgeMap().entrySet()) {
            Multiplicity codEMult;
            PatternEdge domEdge = edgeEntry.getKey();
            PatternEdge codEdge = edgeEntry.getValue();
            Multiplicity domEMult = domEdgeMultMap.get(domEdge);
            int comparison = this.compareMultiplicities(domEMult, codEMult = codEdgeMultMap.get(codEdge));
            if ((result = this.updateResult(result, comparison)) != 0) continue;
            return 0;
        }
        return result;
    }

    private boolean passBasicChecks(PatternShape dom, PatternShape cod) {
        return dom.nodeCount() == cod.nodeCount() && dom.edgeCount() == cod.edgeCount();
    }

    private int compareMultiplicities(Multiplicity domMult, Multiplicity codMult) {
        int result = 0;
        if (domMult.equals(codMult)) {
            result |= 1;
        }
        if (domMult.subsumes(codMult)) {
            result |= 2;
        }
        if (codMult.subsumes(domMult)) {
            result |= 4;
        }
        return result;
    }

    private int updateResult(int result, int comparison) {
        return result & comparison;
    }

    @Override
    public <N extends Node, E extends Edge> boolean areIsomorphic(Graph dom, Graph cod, Node[] domNodes, Node[] codNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <N extends Node, E extends Edge> Morphism<N, E> getIsomorphism(Graph dom, Graph cod) {
        throw new UnsupportedOperationException();
    }
}

