/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.Util;
import groove.abstraction.pattern.shape.AbstractPatternNode;
import groove.grammar.host.HostGraph;

public final class TypeNode
extends AbstractPatternNode {
    static final String PREFIX = "t";
    private final HostGraph pattern;
    private int layer;

    public TypeNode(int nr, HostGraph pattern) {
        super(nr);
        this.pattern = pattern;
        this.layer = -1;
    }

    @Override
    public boolean setFixed() {
        return this.getPattern().setFixed();
    }

    @Override
    public boolean isFixed() {
        return this.getPattern().isFixed();
    }

    @Override
    protected String getToStringPrefix() {
        return PREFIX;
    }

    @Override
    public HostGraph getPattern() {
        return this.pattern;
    }

    @Override
    public int getLayer() {
        int result = this.layer;
        if (result < 0) {
            assert (this.isFixed());
            this.layer = result = Util.getBinaryEdgesCount(this.pattern);
        }
        return result;
    }

    @Override
    public boolean isNodePattern() {
        return this.getLayer() == 0;
    }

    @Override
    public boolean isEdgePattern() {
        return this.getLayer() == 1;
    }
}

