/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.trans.PatternRule;
import java.util.Map;

public final class MatcherFactory {
    private static final MatcherFactory instance = new MatcherFactory();
    private final Map<PatternRule, Matcher> injMatcherMap = new MyHashMap<PatternRule, Matcher>();
    private final Map<PatternRule, Matcher> matcherMap = new MyHashMap<PatternRule, Matcher>();

    public static MatcherFactory instance() {
        return instance;
    }

    private MatcherFactory() {
    }

    public Matcher getMatcher(PatternRule pRule, boolean injective) {
        Map<PatternRule, Matcher> map = this.getMap(injective);
        Matcher result = map.get(pRule);
        if (result == null) {
            result = new Matcher(pRule, injective);
            map.put(pRule, result);
        }
        return result;
    }

    private Map<PatternRule, Matcher> getMap(boolean injective) {
        if (injective) {
            return this.injMatcherMap;
        }
        return this.matcherMap;
    }
}

