/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore.strategy;

import groove.abstraction.pattern.explore.strategy.AbstractPatternStrategy;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PGTSAdapter;
import groove.abstraction.pattern.lts.PatternState;

public abstract class ClosingPatternStrategy
extends AbstractPatternStrategy {
    private final ExploreListener exploreListener = new ExploreListener();

    @Override
    public void prepare(PGTS pgts) {
        super.prepare(pgts);
        this.getPGTS().addLTSListener(this.exploreListener);
        this.clearPool();
    }

    @Override
    protected PatternState getNextState() {
        PatternState result = this.getFromPool();
        if (result == null) {
            this.getPGTS().removeLTSListener(this.exploreListener);
        }
        return result;
    }

    protected abstract void putInPool(PatternState var1);

    protected abstract PatternState getFromPool();

    protected abstract void clearPool();

    private class ExploreListener
    extends PGTSAdapter {
        private ExploreListener() {
        }

        @Override
        public void addUpdate(PGTS gts, PatternState state) {
            if (!state.isClosed()) {
                ClosingPatternStrategy.this.putInPool(state);
            }
        }
    }
}

