/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Node;
import java.util.Map;
import java.util.Set;

public final class RuleToShapeMap
extends RuleToHostMap {
    public RuleToShapeMap(ShapeFactory factory) {
        super(factory);
    }

    @Override
    public Map<RuleEdge, ShapeEdge> edgeMap() {
        return super.edgeMap();
    }

    @Override
    public Map<RuleNode, ShapeNode> nodeMap() {
        return super.nodeMap();
    }

    @Override
    public TypeElement putVar(LabelVar var, TypeElement value) {
        assert (!this.isFixed());
        return super.putVar(var, value);
    }

    @Override
    public ShapeEdge mapEdge(RuleEdge key) {
        assert (!this.isFixed());
        return (ShapeEdge)super.mapEdge(key);
    }

    @Override
    public ShapeNode putNode(RuleNode key, HostNode layout) {
        assert (!this.isFixed());
        return (ShapeNode)super.putNode(key, layout);
    }

    @Override
    public ShapeEdge putEdge(RuleEdge key, HostEdge layout) {
        assert (!this.isFixed());
        return (ShapeEdge)super.putEdge(key, layout);
    }

    @Override
    public ShapeNode removeNode(RuleNode key) {
        assert (!this.isFixed());
        return (ShapeNode)super.removeNode(key);
    }

    @Override
    public ShapeEdge removeEdge(RuleEdge key) {
        assert (!this.isFixed());
        return (ShapeEdge)super.removeEdge(key);
    }

    @Override
    public ShapeNode getNode(Node key) {
        return (ShapeNode)super.getNode(key);
    }

    @Override
    public ShapeFactory getFactory() {
        return (ShapeFactory)super.getFactory();
    }

    public RuleToShapeMap clone() {
        RuleToShapeMap result = new RuleToShapeMap(this.getFactory());
        result.putAll(this);
        return result;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException("Map is not fixed as expected.");
        }
    }

    @Override
    public Set<RuleNode> getPreImages(Node node) {
        assert (node instanceof ShapeNode);
        return super.getPreImages(node);
    }

    @Override
    public Set<RuleEdge> getPreImages(Edge edge) {
        assert (edge instanceof ShapeEdge);
        return super.getPreImages(edge);
    }

    public RuleEdge getSelfEdge(RuleNode node, TypeLabel label) {
        RuleEdge result = null;
        for (RuleEdge edge : this.edgeMap().keySet()) {
            if (((RuleLabel)edge.label()).compareTo(label) != 0 || !((RuleNode)edge.source()).equals(node) || !((RuleNode)edge.target()).equals(node)) continue;
            result = edge;
            break;
        }
        return result;
    }

    public Set<ShapeNode> nodeMapValueSet() {
        MyHashSet<ShapeNode> result = new MyHashSet<ShapeNode>();
        result.addAll(this.nodeMap().values());
        return result;
    }

    Set<ShapeEdge> getInconsistentEdges() {
        MyHashSet<ShapeEdge> result = new MyHashSet<ShapeEdge>();
        for (Map.Entry<RuleEdge, ShapeEdge> entry : this.edgeMap().entrySet()) {
            ShapeEdge edgeS;
            RuleEdge edgeR = entry.getKey();
            if (!this.isSrcInconsistent(edgeR, edgeS = entry.getValue()) && !this.isTgtInconsistent(edgeR, edgeS)) continue;
            result.add(edgeS);
        }
        return result;
    }

    boolean isConsistent() {
        boolean result = true;
        for (Map.Entry<RuleEdge, ShapeEdge> entry : this.edgeMap().entrySet()) {
            ShapeEdge edgeS;
            RuleEdge edgeR = entry.getKey();
            if (!this.isSrcInconsistent(edgeR, edgeS = entry.getValue()) && !this.isTgtInconsistent(edgeR, edgeS)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isNodeInconsistent(RuleNode nodeR, ShapeNode expectedImage) {
        return !this.getNode(nodeR).equals(expectedImage);
    }

    private boolean isSrcInconsistent(RuleEdge edgeR, ShapeEdge expectedImage) {
        return this.isNodeInconsistent((RuleNode)edgeR.source(), expectedImage.source());
    }

    private boolean isTgtInconsistent(RuleEdge edgeR, ShapeEdge expectedImage) {
        return this.isNodeInconsistent((RuleNode)edgeR.target(), expectedImage.target());
    }
}

