/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape.iso;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Morphism;
import groove.graph.Node;
import groove.graph.iso.IsoChecker;
import groove.util.Pair;
import java.util.Map;

public final class ShapeIsoChecker
extends IsoChecker {
    public static final boolean CHECK_SUBSUMPTION = true;
    private static final int NON_ISO = 0;
    private static final int DOM_EQUALS_COD = 1;
    private static final int DOM_SUBSUMES_COD = 2;
    private static final int COD_SUBSUMES_DOM = 4;
    private static ShapeIsoChecker strongInstance;
    private static ShapeIsoChecker weakInstance;

    public static ShapeIsoChecker getInstance(boolean strong) {
        if (strongInstance == null) {
            strongInstance = new ShapeIsoChecker(true);
            weakInstance = new ShapeIsoChecker(false);
        }
        return strong ? strongInstance : weakInstance;
    }

    public static boolean areExactlyEqual(Shape s, Shape t) {
        ShapeIsoChecker checker = ShapeIsoChecker.getInstance(true);
        int result = checker.compareShapes(s, t).one();
        return checker.isDomEqualsCod(result);
    }

    private ShapeIsoChecker(boolean strong) {
        super(strong);
    }

    private boolean isDomEqualsCod(int result) {
        return (result & 1) == 1;
    }

    private boolean isDomSubsumesCod(int result) {
        return (result & 2) == 2;
    }

    public boolean isCodSubsumesDom(int result) {
        return (result & 4) == 4;
    }

    public boolean isDomStrictlyLargerThanCod(int result) {
        return this.isDomSubsumesCod(result) && !this.isDomEqualsCod(result);
    }

    public boolean areEqual(int result) {
        boolean equal = this.isDomEqualsCod(result);
        return equal |= this.isCodSubsumesDom(result);
    }

    public boolean areIsomorphic(Shape dom, Shape cod) {
        int result = this.compareShapes(dom, cod).one();
        return this.areEqual(result);
    }

    public Pair<Integer, Morphism<ShapeNode, ShapeEdge>> compareShapes(Shape dom, Shape cod) {
        Pair<Integer, Object> result = new Pair<Integer, Object>(0, null);
        if (!this.passBasicChecks(dom, cod)) {
            return result;
        }
        ShapeIsoChecker isoChecker = ShapeIsoChecker.getInstance(true);
        IsoChecker.IsoCheckerState state = new IsoChecker.IsoCheckerState(this);
        Morphism<ShapeNode, ShapeEdge> morphism = isoChecker.getIsomorphism(dom, cod, state);
        int comparison = 0;
        while (morphism != null) {
            comparison = this.checkIsomorphism(dom, cod, morphism);
            if (comparison != 0) {
                result = new Pair<Integer, Morphism<ShapeNode, ShapeEdge>>(comparison, morphism);
                break;
            }
            morphism = isoChecker.getIsomorphism(dom, cod, state);
            if (morphism == null || state.isPlanEmpty()) break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private int checkIsomorphism(Shape dom, Shape cod, Morphism<ShapeNode, ShapeEdge> morphism) {
        int result = 7;
        Map<ShapeNode, Multiplicity> domMultMap = dom.getNodeMultMap();
        Map<ShapeNode, Multiplicity> codMultMap = cod.getNodeMultMap();
        for (Map.Entry<ShapeNode, ShapeNode> nodeEntry : morphism.nodeMap().entrySet()) {
            Multiplicity codNMult;
            ShapeNode shapeNode = nodeEntry.getKey();
            ShapeNode codNode = nodeEntry.getValue();
            Multiplicity multiplicity = domMultMap.get(shapeNode);
            int comparison = this.compareMultiplicities(multiplicity, codNMult = codMultMap.get(codNode));
            if ((result = this.updateResult(result, comparison)) != 0) continue;
            return 0;
        }
        EdgeSignatureStore domStore = dom.getEdgeSigStore();
        EdgeSignatureStore codStore = cod.getEdgeSigStore();
        for (Map.Entry entry : morphism.edgeMap().entrySet()) {
            ShapeEdge shapeEdge = (ShapeEdge)entry.getKey();
            ShapeEdge codEdge = (ShapeEdge)entry.getValue();
            if (shapeEdge.getRole() != EdgeRole.BINARY) continue;
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                Multiplicity codEMult;
                EdgeMultDir direction = edgeMultDirArray[n2];
                Multiplicity domEMult = domStore.getMult(shapeEdge, direction);
                int comparison = this.compareMultiplicities(domEMult, codEMult = codStore.getMult(codEdge, direction));
                if ((result = this.updateResult(result, comparison)) == 0) {
                    return 0;
                }
                ++n2;
            }
        }
        NodeEquivClass nodeEquivClass = new NodeEquivClass(dom.getFactory());
        EquivRelation<ShapeNode> codEr = cod.getEquivRelation();
        for (EquivClass equivClass : dom.getEquivRelation()) {
            void var9_13;
            ShapeNode codNode = null;
            for (ShapeNode domNode : equivClass) {
                codNode = (ShapeNode)morphism.getNode(domNode);
                var9_13.add(codNode);
            }
            EquivClass<Object> codEc = codEr.getEquivClassOf(codNode);
            if (!codEc.equals(var9_13)) {
                return 0;
            }
            NodeEquivClass nodeEquivClass2 = new NodeEquivClass(dom.getFactory());
        }
        return result;
    }

    private boolean passBasicChecks(Shape dom, Shape cod) {
        return dom.nodeCount() == cod.nodeCount() && dom.edgeCount() == cod.edgeCount() && dom.getEquivRelation().size() == cod.getEquivRelation().size() && dom.getEdgeSigSet().size() == cod.getEdgeSigSet().size();
    }

    private int compareMultiplicities(Multiplicity domMult, Multiplicity codMult) {
        int result = 0;
        if (domMult.equals(codMult)) {
            result |= 1;
        }
        if (domMult.subsumes(codMult)) {
            result |= 2;
        }
        if (codMult.subsumes(domMult)) {
            result |= 4;
        }
        return result;
    }

    private int updateResult(int result, int comparison) {
        return result & comparison;
    }

    @Override
    public boolean areIsomorphic(Graph dom, Graph cod, Node[] domNodes, Node[] codNodes) {
        throw new UnsupportedOperationException();
    }

    public Morphism<Node, Edge> getIsomorphism(Graph dom, Graph cod) {
        throw new UnsupportedOperationException();
    }

    public static /* bridge */ /* synthetic */ IsoChecker getInstance(boolean bl) {
        return ShapeIsoChecker.getInstance(bl);
    }
}

