/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.ShapeCache;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.shape.ShapeStore;
import groove.grammar.type.TypeLabel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ShapeStore2
implements ShapeStore {
    private ShapeEdge[] edges;
    private char[] nodeEquivArray;
    private char[] nodeMultArray;
    private Object[] inEdgeSigs;
    private Object[] outEdgeSigs;
    public static final ShapeStore PROTOTYPE = new ShapeStore2();
    private static final List<Character> canon = new ArrayList<Character>();

    private ShapeStore2() {
    }

    @Override
    public ShapeStore flatten(ShapeCache cache) {
        ShapeStore2 result = new ShapeStore2();
        result.edges = cache.getEdgeSet().toArray(new ShapeEdge[0]);
        char[] nodeEquivArray = this.flattenNodeEquiv(cache);
        result.nodeEquivArray = nodeEquivArray;
        result.nodeMultArray = this.flattenNodeMultMap(cache);
        Map<EdgeMultDir, Object[]> edgeSigs = this.flattenEdgeSigSet(cache, nodeEquivArray);
        result.inEdgeSigs = edgeSigs.get((Object)EdgeMultDir.INCOMING);
        result.outEdgeSigs = edgeSigs.get((Object)EdgeMultDir.OUTGOING);
        assert (nodeEquivArray != null);
        return result;
    }

    private Map<EdgeMultDir, Object[]> flattenEdgeSigSet(ShapeCache cache, char[] nodeEquiv) {
        EdgeSignatureStore store = cache.getEdgeSigStore();
        EnumMap<EdgeMultDir, Object[]> result = new EnumMap<EdgeMultDir, Object[]>(EdgeMultDir.class);
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir dir = edgeMultDirArray[n2];
            result.put(dir, new Object[store.getSigCount(dir) * 4]);
            ++n2;
        }
        Map<EdgeSignature, Multiplicity> sigSet = store.getMultMap();
        int[] ixs = new int[EdgeMultDir.values().length];
        for (Map.Entry entry : sigSet.entrySet()) {
            EdgeSignature es = (EdgeSignature)entry.getKey();
            EdgeMultDir dir = es.getDirection();
            Object[] array = (Object[])result.get((Object)dir);
            int ix = ixs[dir.ordinal()];
            array[ix] = es.getNode();
            array[++ix] = es.getLabel();
            int nodeNr = ((ShapeNode)es.getEquivClass().iterator().next()).getNumber();
            array[++ix] = ShapeStore2.getCanon(nodeEquiv[nodeNr]);
            array[++ix] = entry.getValue();
            ixs[dir.ordinal()] = ++ix;
        }
        return result;
    }

    private char[] flattenNodeMultMap(ShapeCache cache) {
        char[] result = new char[cache.getNodeStoreSize()];
        for (Map.Entry multEntry : cache.getNodeMultMap().entrySet()) {
            result[((ShapeNode)multEntry.getKey()).getNumber()] = ((Multiplicity)multEntry.getValue()).getIndex();
        }
        return result;
    }

    private char[] flattenNodeEquiv(ShapeCache cache) {
        char[] result = new char[cache.getNodeStoreSize()];
        int cellIx = 1;
        for (EquivClass equivClass : cache.getEquivRel()) {
            for (ShapeNode node : equivClass) {
                result[node.getNumber()] = cellIx;
            }
            cellIx = (char)(cellIx + 1);
            assert (cellIx != 0) : "Too many cells in the node partition";
        }
        return result;
    }

    @Override
    public void fill(ShapeCache cache) {
        assert (this.edges != null);
        this.setNodeSet(cache);
        this.setEdgeSet(cache);
        this.setNodeEquiv(cache);
        this.setNodeMultMap(cache);
        this.setEdgeSigSets(cache);
    }

    private void setNodeSet(ShapeCache cache) {
        ShapeFactory factory = cache.getFactory();
        Set<ShapeNode> nodeSet = cache.createElementSet();
        char[] nodeEquiv = this.nodeEquivArray;
        int i = 0;
        while (i < nodeEquiv.length) {
            if (nodeEquiv[i] != '\u0000') {
                nodeSet.add(factory.getNode(i));
            }
            ++i;
        }
        cache.setNodeSet(nodeSet);
    }

    private void setEdgeSet(ShapeCache cache) {
        Set<ShapeEdge> edgeSet = cache.createElementSet();
        ShapeEdge[] edges = this.edges;
        int i = 0;
        while (i < edges.length) {
            edgeSet.add(edges[i]);
            ++i;
        }
        cache.setEdgeSet(edgeSet);
    }

    private void setNodeEquiv(ShapeCache cache) {
        ShapeFactory factory = cache.getFactory();
        EquivRelation<ShapeNode> equivRel = cache.createNodeEquiv();
        char[] nodeEquiv = this.nodeEquivArray;
        ArrayList cells = new ArrayList(nodeEquiv.length);
        for (ShapeNode node : cache.getNodeSet()) {
            char cellIx = nodeEquiv[node.getNumber()];
            while (cellIx > cells.size()) {
                cells.add(new NodeEquivClass(factory));
            }
            ((EquivClass)cells.get(cellIx - '\u0001')).add(node);
        }
        equivRel.addAll(cells);
        cache.setEquivRel(equivRel);
    }

    private void setNodeMultMap(ShapeCache cache) {
        MyHashMap<ShapeNode, Multiplicity> nodeMultMap = cache.createNodeMultMap();
        char[] nodeMultArray = this.nodeMultArray;
        for (ShapeNode node : cache.getNodeSet()) {
            Multiplicity mult = Multiplicity.getMultiplicity(nodeMultArray[node.getNumber()], Multiplicity.MultKind.NODE_MULT);
            nodeMultMap.put(node, mult);
        }
        cache.setNodeMultMap(nodeMultMap);
    }

    private void setEdgeSigSets(ShapeCache cache) {
        EdgeSignatureStore store = cache.getGraph().createEdgeSigStore();
        this.addToSigStore(cache, this.inEdgeSigs, EdgeMultDir.INCOMING, store);
        this.addToSigStore(cache, this.outEdgeSigs, EdgeMultDir.OUTGOING, store);
        cache.setEdgeSigStore(store);
    }

    private void addToSigStore(ShapeCache cache, Object[] records, EdgeMultDir dir, EdgeSignatureStore store) {
        ShapeFactory factory = cache.getFactory();
        char[] nodeEquivArray = this.nodeEquivArray;
        int i = 0;
        while (i < records.length) {
            ShapeNode node = (ShapeNode)records[i];
            TypeLabel label = (TypeLabel)records[++i];
            char targetEc = ((Character)records[++i]).charValue();
            ++i;
            NodeEquivClass<ShapeNode> ec = new NodeEquivClass<ShapeNode>(factory);
            int n = 0;
            while (n < nodeEquivArray.length) {
                if (nodeEquivArray[n] == targetEc) {
                    ec.add(factory.getNode(n));
                }
                ++n;
            }
            EdgeSignature sig = cache.getGraph().createEdgeSignature(dir, node, label, ec);
            Multiplicity mult = (Multiplicity)records[i];
            ++i;
            store.setEdgeMult(sig, mult);
        }
    }

    private static Character getCanon(char v) {
        if (v >= canon.size()) {
            char i = (char)canon.size();
            while (i <= v) {
                canon.add(new Character(i));
                i = (char)(i + '\u0001');
            }
        }
        return canon.get(v);
    }
}

