/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.ShapeCache;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeGraph;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.shape.ShapeStore;
import groove.grammar.type.TypeLabel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ShapeStore1
implements ShapeStore {
    private ShapeEdge[] edges;
    private char[] nodeEquivArray;
    private char[] nodeMultArray;
    private EdgeRecord[] inEdgeSigs;
    private EdgeRecord[] outEdgeSigs;
    public static final ShapeStore PROTOTYPE = new ShapeStore1();
    private static Map<EdgeRecord, EdgeRecord> canonMap = new HashMap<EdgeRecord, EdgeRecord>();

    private ShapeStore1() {
    }

    @Override
    public ShapeStore flatten(ShapeCache cache) {
        ShapeStore1 result = new ShapeStore1();
        result.edges = cache.getEdgeSet().toArray(new ShapeEdge[0]);
        char[] nodeEquivArray = this.flattenNodeEquiv(cache);
        result.nodeEquivArray = nodeEquivArray;
        result.nodeMultArray = this.flattenNodeMultMap(cache);
        Map<EdgeMultDir, EdgeRecord[]> edgeSigs = this.flattenEdgeSigSet(cache, nodeEquivArray);
        result.inEdgeSigs = edgeSigs.get((Object)EdgeMultDir.INCOMING);
        result.outEdgeSigs = edgeSigs.get((Object)EdgeMultDir.OUTGOING);
        assert (nodeEquivArray != null);
        return result;
    }

    private Map<EdgeMultDir, EdgeRecord[]> flattenEdgeSigSet(ShapeCache cache, char[] nodeEquiv) {
        EdgeSignatureStore store = cache.getEdgeSigStore();
        EnumMap<EdgeMultDir, EdgeRecord[]> result = new EnumMap<EdgeMultDir, EdgeRecord[]>(EdgeMultDir.class);
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir dir = edgeMultDirArray[n2];
            result.put(dir, new EdgeRecord[store.getSigCount(dir)]);
            ++n2;
        }
        Map<EdgeSignature, Multiplicity> multMap = store.getMultMap();
        int[] ix = new int[EdgeMultDir.values().length];
        for (Map.Entry entry : multMap.entrySet()) {
            EdgeSignature sig = (EdgeSignature)entry.getKey();
            EdgeMultDir dir = sig.getDirection();
            ((EdgeRecord[])result.get((Object)((Object)dir)))[ix[dir.ordinal()]] = this.canonise(new EdgeRecord((EdgeSignature)entry.getKey(), (Multiplicity)entry.getValue(), cache.getFactory(), nodeEquiv));
            int n3 = dir.ordinal();
            ix[n3] = ix[n3] + 1;
        }
        return result;
    }

    private char[] flattenNodeMultMap(ShapeCache cache) {
        char[] result = new char[cache.getNodeStoreSize()];
        for (Map.Entry multEntry : cache.getNodeMultMap().entrySet()) {
            result[((ShapeNode)multEntry.getKey()).getNumber()] = ((Multiplicity)multEntry.getValue()).getIndex();
        }
        return result;
    }

    private char[] flattenNodeEquiv(ShapeCache cache) {
        char[] result = new char[cache.getNodeStoreSize()];
        int cellIx = 1;
        for (EquivClass equivClass : cache.getEquivRel()) {
            for (ShapeNode node : equivClass) {
                result[node.getNumber()] = cellIx;
            }
            cellIx = (char)(cellIx + 1);
            assert (cellIx != 0) : "Too many cells in the node partition";
        }
        return result;
    }

    @Override
    public void fill(ShapeCache cache) {
        assert (this.edges != null);
        this.setNodeSet(cache);
        this.setEdgeSet(cache);
        this.setNodeEquiv(cache);
        this.setNodeMultMap(cache);
        this.setEdgeSigSets(cache);
    }

    private void setNodeSet(ShapeCache cache) {
        ShapeFactory factory = cache.getFactory();
        Set<ShapeNode> nodeSet = cache.createElementSet();
        char[] nodeEquiv = this.nodeEquivArray;
        int i = 0;
        while (i < nodeEquiv.length) {
            if (nodeEquiv[i] != '\u0000') {
                nodeSet.add(factory.getNode(i));
            }
            ++i;
        }
        cache.setNodeSet(nodeSet);
    }

    private void setEdgeSet(ShapeCache cache) {
        Set<ShapeEdge> edgeSet = cache.createElementSet();
        ShapeEdge[] edges = this.edges;
        int i = 0;
        while (i < edges.length) {
            edgeSet.add(edges[i]);
            ++i;
        }
        cache.setEdgeSet(edgeSet);
    }

    private void setNodeEquiv(ShapeCache cache) {
        ShapeFactory factory = cache.getFactory();
        EquivRelation<ShapeNode> equivRel = cache.createNodeEquiv();
        char[] nodeEquiv = this.nodeEquivArray;
        ArrayList cells = new ArrayList(nodeEquiv.length);
        for (ShapeNode node : cache.getNodeSet()) {
            char cellIx = nodeEquiv[node.getNumber()];
            while (cellIx > cells.size()) {
                cells.add(new NodeEquivClass(factory));
            }
            ((EquivClass)cells.get(cellIx - '\u0001')).add(node);
        }
        equivRel.addAll(cells);
        cache.setEquivRel(equivRel);
    }

    private void setNodeMultMap(ShapeCache cache) {
        MyHashMap<ShapeNode, Multiplicity> nodeMultMap = cache.createNodeMultMap();
        char[] nodeMultArray = this.nodeMultArray;
        for (ShapeNode node : cache.getNodeSet()) {
            Multiplicity mult = Multiplicity.getMultiplicity(nodeMultArray[node.getNumber()], Multiplicity.MultKind.NODE_MULT);
            nodeMultMap.put(node, mult);
        }
        cache.setNodeMultMap(nodeMultMap);
    }

    private void setEdgeSigSets(ShapeCache cache) {
        ShapeGraph shape = cache.getGraph();
        EdgeSignatureStore store = shape.createEdgeSigStore();
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir dir = edgeMultDirArray[n2];
            EdgeRecord[] records = dir == EdgeMultDir.INCOMING ? this.inEdgeSigs : this.outEdgeSigs;
            int i = 0;
            while (i < records.length) {
                EdgeRecord record = records[i];
                store.setEdgeMult(record.getSig(shape, dir, this.nodeEquivArray), record.getMult());
                ++i;
            }
            ++n2;
        }
        cache.setEdgeSigStore(store);
    }

    private EdgeRecord canonise(EdgeRecord record) {
        EdgeRecord result = canonMap.get(record);
        if (result == null) {
            result = record;
            canonMap.put(result, record);
        }
        return result;
    }

    private static class EdgeRecord {
        final int source;
        final TypeLabel label;
        final char targetEc;
        final char multIndex;

        public EdgeRecord(EdgeSignature sig, Multiplicity mult, ShapeFactory factory, char[] nodeEquiv) {
            this.source = sig.getNode().getNumber();
            this.label = sig.getLabel();
            this.targetEc = nodeEquiv[((ShapeNode)sig.getEquivClass().iterator().next()).getNumber()];
            this.multIndex = mult.getIndex();
        }

        public EdgeSignature getSig(ShapeGraph shape, EdgeMultDir dir, char[] nodeEquiv) {
            ShapeFactory factory = shape.getFactory();
            NodeEquivClass<ShapeNode> cell = new NodeEquivClass<ShapeNode>(factory);
            int i = 0;
            while (i < nodeEquiv.length) {
                if (nodeEquiv[i] == this.targetEc) {
                    cell.add(factory.getNode(i));
                }
                ++i;
            }
            return shape.createEdgeSignature(dir, factory.getNode(this.source), this.label, cell);
        }

        public Multiplicity getMult() {
            return Multiplicity.getMultiplicity(this.multIndex, Multiplicity.MultKind.EDGE_MULT);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + this.multIndex;
            result = 31 * result + this.source;
            result = 31 * result + this.targetEc;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeRecord other = (EdgeRecord)obj;
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.multIndex != other.multIndex) {
                return false;
            }
            if (this.source != other.source) {
                return false;
            }
            return this.targetEc == other.targetEc;
        }
    }
}

