/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeGraph;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EdgeSignatureStore {
    private final ShapeGraph shape;
    private final int[] sigCount;
    private Map<EdgeMultDir, Edge2SigMap> edge2SigMaps;
    private Map<EdgeMultDir, Node2SigMap> node2SigMaps;
    private final Map<EdgeSignature, Multiplicity> sig2MultMap;
    private final Map<EdgeSignature, Set<ShapeEdge>> sig2EdgeMap;
    private static final boolean ASSERT_EXTRA = false;

    public EdgeSignatureStore(ShapeGraph shape) {
        this.shape = shape;
        this.sig2MultMap = new HashMap<EdgeSignature, Multiplicity>();
        this.sig2EdgeMap = new HashMap<EdgeSignature, Set<ShapeEdge>>();
        this.sigCount = new int[EdgeMultDir.values().length];
    }

    public Multiplicity setEdgeMult(EdgeSignature sig, Multiplicity value) {
        Multiplicity result = this.sig2MultMap.put(sig, value);
        if (result == null) {
            this.sig2EdgeMap.put(sig, sig.findEdges(this.shape));
            this.addToEdge2SigMap(sig);
            this.addToNode2SigMap(sig);
            int n = sig.getDirection().ordinal();
            this.sigCount[n] = this.sigCount[n] + 1;
        }
        assert (this.isConsistent());
        return result;
    }

    public Multiplicity removeSig(EdgeSignature sig) {
        Multiplicity result = this.sig2MultMap.remove(sig);
        if (result != null) {
            this.removeFromNode2SigMap(sig);
            this.removeFromEdge2SigMap(sig);
            Set<ShapeEdge> edges = this.sig2EdgeMap.remove(sig);
            int n = sig.getDirection().ordinal();
            this.sigCount[n] = this.sigCount[n] - 1;
            assert (edges != null);
        }
        assert (this.isConsistent()) : "Inconsistent " + this;
        return result;
    }

    public void addEdge(ShapeEdge edge) {
        assert (edge.getRole() == EdgeRole.BINARY);
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir dir = edgeMultDirArray[n2];
            EdgeSignature sig = this.shape.createEdgeSignature(dir, edge);
            boolean result = !this.sig2MultMap.containsKey(sig);
            this.addToEdge2SigMap(edge, sig);
            if (result) {
                this.sig2MultMap.put(sig, Multiplicity.ONE_EDGE_MULT);
                HashSet<ShapeEdge> edges = new HashSet<ShapeEdge>();
                edges.add(edge);
                this.sig2EdgeMap.put(sig, edges);
                this.addToNode2SigMap(sig);
                int n3 = dir.ordinal();
                this.sigCount[n3] = this.sigCount[n3] + 1;
            } else {
                this.sig2EdgeMap.get(sig).add(edge);
            }
            ++n2;
        }
        assert (this.isConsistent()) : "Inconsistent " + this;
    }

    public void removeEdge(ShapeEdge edge) {
        assert (edge.getRole() == EdgeRole.BINARY);
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir dir = edgeMultDirArray[n2];
            EdgeSignature sig = (EdgeSignature)this.getEdge2SigMap(dir).remove(edge);
            if (sig != null) {
                Set<ShapeEdge> sigEdges = this.sig2EdgeMap.get(sig);
                boolean removed = sigEdges.remove(edge);
                assert (removed);
                if (sigEdges.isEmpty()) {
                    this.removeSig(sig);
                }
            }
            ++n2;
        }
        assert (this.isConsistent()) : "Inconsistent " + this;
    }

    public void clear() {
        this.sig2MultMap.clear();
        this.sig2EdgeMap.clear();
        this.edge2SigMaps = null;
        this.node2SigMaps = null;
        Arrays.fill(this.sigCount, 0);
    }

    public Set<ShapeEdge> getEdges(EdgeSignature sig) {
        Set<ShapeEdge> result = this.sig2EdgeMap.get(sig);
        return result == null ? null : Collections.unmodifiableSet(result);
    }

    public EdgeSignature getSig(ShapeEdge edge, EdgeMultDir dir) {
        assert (edge.getRole() == EdgeRole.BINARY);
        EdgeSignature result = (EdgeSignature)this.getEdge2SigMap(dir).get(edge);
        return result;
    }

    public EdgeSignature getSig(EdgeMultDir direction, ShapeNode node, TypeLabel label, EquivClass<ShapeNode> ec) {
        EdgeSignature result = null;
        Set<EdgeSignature> nodeSigs = this.getSigs(node, direction);
        if (nodeSigs != null) {
            for (EdgeSignature es : nodeSigs) {
                if (!es.getLabel().equals(label) || !es.hasSameEquivClass(ec)) continue;
                result = es;
                break;
            }
        }
        return result;
    }

    public Multiplicity getMult(EdgeSignature sig) {
        return this.sig2MultMap.get(sig);
    }

    public Multiplicity getMult(ShapeEdge edge, EdgeMultDir dir) {
        assert (edge.getRole() == EdgeRole.BINARY);
        Multiplicity result = null;
        EdgeSignature sig = this.getSig(edge, dir);
        if (sig != null) {
            result = this.getMult(sig);
            assert (result != null);
        }
        return result;
    }

    public Map<EdgeSignature, Multiplicity> getMultMap() {
        return this.sig2MultMap;
    }

    public Set<EdgeSignature> getSigs(ShapeNode node, EdgeMultDir dir) {
        Set result = (Set)this.getNode2SigMap(dir).get(node);
        return result == null ? null : Collections.unmodifiableSet(result);
    }

    public int getSigCount(EdgeMultDir dir) {
        return this.sigCount[dir.ordinal()];
    }

    public String toString() {
        return "EdgeSignatureStore:\n  edge2SigMap=" + this.edge2SigMaps + "\n  node2SigMap=" + this.node2SigMaps + "\n  sig2MultMap=" + this.sig2MultMap + "\n  sig2EdgeMap=" + this.sig2EdgeMap;
    }

    public void copyFrom(EdgeSignatureStore other) {
        EdgeMultDir dir;
        int n;
        EdgeMultDir[] edgeMultDirArray;
        this.sig2EdgeMap.clear();
        for (Map.Entry<EdgeSignature, Set<ShapeEdge>> entry : other.sig2EdgeMap.entrySet()) {
            this.sig2EdgeMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        this.sig2MultMap.clear();
        this.sig2MultMap.putAll(other.sig2MultMap);
        if (other.edge2SigMaps == null) {
            this.edge2SigMaps = null;
        } else {
            this.edge2SigMaps = this.createEdge2SigMaps();
            edgeMultDirArray = EdgeMultDir.values();
            n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                dir = edgeMultDirArray[n2];
                this.edge2SigMaps.put(dir, new Edge2SigMap(other.edge2SigMaps.get((Object)dir)));
                ++n2;
            }
        }
        if (other.node2SigMaps == null) {
            this.node2SigMaps = null;
        } else {
            this.node2SigMaps = this.createNode2SigMaps();
            edgeMultDirArray = EdgeMultDir.values();
            n = edgeMultDirArray.length;
            int n3 = 0;
            while (n3 < n) {
                dir = edgeMultDirArray[n3];
                this.node2SigMaps.put(dir, new Node2SigMap(other.node2SigMaps.get((Object)dir)));
                ++n3;
            }
        }
        System.arraycopy(other.sigCount, 0, this.sigCount, 0, other.sigCount.length);
    }

    private boolean hasEdge2SigMap() {
        return this.edge2SigMaps != null;
    }

    private Edge2SigMap getEdge2SigMap(EdgeMultDir dir) {
        if (this.edge2SigMaps == null) {
            this.edge2SigMaps = this.createEdge2SigMaps();
            Map<EdgeMultDir, Edge2SigMap> result = this.edge2SigMaps;
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir any = edgeMultDirArray[n2];
                result.put(any, new Edge2SigMap());
                ++n2;
            }
            for (EdgeSignature sig : this.sig2MultMap.keySet()) {
                Edge2SigMap map = result.get((Object)sig.getDirection());
                for (ShapeEdge edge : this.getEdges(sig)) {
                    map.put(edge, sig);
                }
            }
        }
        return this.edge2SigMaps.get((Object)dir);
    }

    private void addToEdge2SigMap(EdgeSignature sig) {
        Map<EdgeMultDir, Edge2SigMap> maps = this.edge2SigMaps;
        if (maps != null) {
            Edge2SigMap map = maps.get((Object)sig.getDirection());
            for (ShapeEdge edge : this.getEdges(sig)) {
                map.put(edge, sig);
            }
        }
    }

    private void addToEdge2SigMap(ShapeEdge edge, EdgeSignature sig) {
        Map<EdgeMultDir, Edge2SigMap> map = this.edge2SigMaps;
        if (map != null) {
            map.get((Object)sig.getDirection()).put(edge, sig);
        }
    }

    private void removeFromEdge2SigMap(EdgeSignature sig) {
        Map<EdgeMultDir, Edge2SigMap> maps = this.edge2SigMaps;
        if (maps != null) {
            maps.get((Object)sig.getDirection()).keySet().removeAll(this.getEdges(sig));
        }
    }

    private Map<EdgeMultDir, Edge2SigMap> createEdge2SigMaps() {
        return new EnumMap<EdgeMultDir, Edge2SigMap>(EdgeMultDir.class);
    }

    private boolean isConsistent() {
        boolean result = true;
        if (!this.sig2EdgeMap.keySet().equals(this.sig2MultMap.keySet())) {
            return false;
        }
        return result;
    }

    boolean isComplete() {
        boolean result = true;
        if (this.hasEdge2SigMap()) {
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir dir = edgeMultDirArray[n2];
                if (!this.getEdge2SigMap(dir).keySet().equals(Util.getBinaryEdges(this.shape))) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private Node2SigMap getNode2SigMap(EdgeMultDir dir) {
        if (this.node2SigMaps == null) {
            this.node2SigMaps = this.createNode2SigMaps();
            Map<EdgeMultDir, Node2SigMap> maps = this.node2SigMaps;
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir any = edgeMultDirArray[n2];
                maps.put(any, new Node2SigMap());
                ++n2;
            }
            for (EdgeSignature sig : this.sig2MultMap.keySet()) {
                maps.get((Object)sig.getDirection()).add(sig);
            }
        }
        return this.node2SigMaps.get((Object)dir);
    }

    private void addToNode2SigMap(EdgeSignature key) {
        Map<EdgeMultDir, Node2SigMap> maps = this.node2SigMaps;
        if (maps != null) {
            maps.get((Object)key.getDirection()).add(key);
        }
    }

    private void removeFromNode2SigMap(EdgeSignature sig) {
        Map<EdgeMultDir, Node2SigMap> map = this.node2SigMaps;
        if (map != null) {
            ((Set)map.get((Object)sig.getDirection()).get(sig.getNode())).remove(sig);
        }
    }

    private Map<EdgeMultDir, Node2SigMap> createNode2SigMaps() {
        return new EnumMap<EdgeMultDir, Node2SigMap>(EdgeMultDir.class);
    }

    private static class Edge2SigMap
    extends HashMap<ShapeEdge, EdgeSignature> {
        public Edge2SigMap() {
        }

        public Edge2SigMap(Edge2SigMap m) {
            super(m);
        }
    }

    private static class Node2SigMap
    extends HashMap<ShapeNode, Set<EdgeSignature>> {
        public Node2SigMap() {
        }

        public Node2SigMap(Node2SigMap m) {
            for (Map.Entry entry : m.entrySet()) {
                this.put((ShapeNode)entry.getKey(), new HashSet((Collection)entry.getValue()));
            }
        }

        public void add(EdgeSignature sig) {
            ShapeNode incident = sig.getNode();
            HashSet<EdgeSignature> nodeSigs = (HashSet<EdgeSignature>)this.get(incident);
            if (nodeSigs == null) {
                nodeSigs = new HashSet<EdgeSignature>();
                this.put(incident, nodeSigs);
            }
            nodeSigs.add(sig);
        }
    }
}

