/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.match;

import groove.abstraction.MyHashMap;
import groove.grammar.Condition;
import groove.grammar.Rule;
import groove.grammar.rule.Anchor;
import groove.match.Matcher;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import java.util.Map;

public final class ReverseMatcherStore {
    private static Map<Rule, Matcher> store;

    private static boolean isInitialised() {
        return store != null;
    }

    public static void initialise() {
        store = new MyHashMap<Rule, Matcher>();
    }

    public static void terminate() {
        store = null;
    }

    public static Matcher getMatcher(Rule rule) {
        assert (ReverseMatcherStore.isInitialised());
        Matcher result = store.get(rule);
        if (result == null) {
            MatcherFactory factory = MatcherFactory.instance();
            factory.setEngine(SearchEngine.SearchMode.REVERSE);
            Condition condition = rule.getCondition();
            result = factory.createMatcher(condition, new Anchor(rule.lhs()));
            store.put(rule, result);
        }
        return result;
    }

    private ReverseMatcherStore() {
    }
}

