/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction;

import groove.abstraction.AbsParameters;
import groove.abstraction.AbstractionKind;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.pattern.PatternAbsParam;
import groove.graph.Edge;
import groove.graph.Node;
import java.util.Set;

public final class Multiplicity {
    public static final int MAX_BOUND = 8;
    public static final int OMEGA = Integer.MAX_VALUE;
    private static final Multiplicity[][] GLOBAL_MULT_STORE = new Multiplicity[MultKind.values().length][];
    private static final Multiplicity[][][] INDEXED_MULT_STORE = new Multiplicity[MultKind.values().length][][];
    private static final Multiplicity[][] OMEGA_MULT_STORE = new Multiplicity[MultKind.values().length][];
    private static AbstractionKind currentAbstraction;
    public static final Multiplicity ZERO_EDGE_MULT;
    public static final Multiplicity ZERO_NODE_MULT;
    public static final Multiplicity ONE_EDGE_MULT;
    public static final Multiplicity ONE_NODE_MULT;
    public static final Multiplicity ZERO_PLUS_EDGE_MULT;
    private final int i;
    private final int j;
    private final MultKind kind;
    private final char index;
    private final int hashCode;

    static {
        Multiplicity.initMultStore();
        currentAbstraction = AbstractionKind.NEIGH;
        ZERO_EDGE_MULT = Multiplicity.getMultiplicity(0, 0, MultKind.EDGE_MULT);
        ZERO_NODE_MULT = Multiplicity.getMultiplicity(0, 0, MultKind.NODE_MULT);
        ONE_EDGE_MULT = Multiplicity.getMultiplicity(1, 1, MultKind.EDGE_MULT);
        ONE_NODE_MULT = Multiplicity.getMultiplicity(1, 1, MultKind.NODE_MULT);
        ZERO_PLUS_EDGE_MULT = Multiplicity.getMultiplicity(0, Integer.MAX_VALUE, MultKind.EDGE_MULT);
    }

    public static void setAbstractionKind(AbstractionKind absKind) {
        currentAbstraction = absKind;
    }

    private static AbsParameters getSetAbsParameters() {
        switch (currentAbstraction) {
            case NEIGH: {
                return NeighAbsParam.getInstance();
            }
            case PATTERN: {
                return PatternAbsParam.getInstance();
            }
        }
        assert (false);
        return null;
    }

    public static int getBound(MultKind kind) {
        AbsParameters params = Multiplicity.getSetAbsParameters();
        switch (kind) {
            case NODE_MULT: {
                return params.getNodeMultBound();
            }
            case EDGE_MULT: {
                return params.getEdgeMultBound();
            }
            case EQSYS_MULT: {
                return (params.getNodeMultBound() + 1) * (params.getEdgeMultBound() + 1) - 1;
            }
        }
        assert (false);
        return 0;
    }

    private static boolean isInNOmega(int i) {
        return i >= 0;
    }

    private static boolean isInN(int i) {
        return Multiplicity.isInNOmega(i) && i != Integer.MAX_VALUE;
    }

    private static int getCardinality(int b) {
        return (b * b + 5 * b + 6) / 2;
    }

    private static void initMultStore() {
        int b = 8;
        char c = Multiplicity.getCardinality(b);
        MultKind[] multKindArray = MultKind.values();
        int n = multKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            MultKind kind = multKindArray[n2];
            Multiplicity[] globalStore = new Multiplicity[c];
            Multiplicity[][] indexedStore = new Multiplicity[b + 2][b + 1];
            Multiplicity[] omegaStore = new Multiplicity[b + 2];
            char index = '\u0000';
            int i = 0;
            while (i <= b + 1) {
                Multiplicity mult;
                int j = i;
                while (j <= b) {
                    Multiplicity mult2;
                    Multiplicity multiplicity = mult2 = new Multiplicity(i, j, kind, index);
                    indexedStore[i][j] = multiplicity;
                    globalStore[index] = multiplicity;
                    index = (char)(index + '\u0001');
                    assert (index != '\u0000') : "Too many multiplicity values";
                    ++j;
                }
                globalStore[index] = omegaStore[i] = (mult = new Multiplicity(i, Integer.MAX_VALUE, kind, index));
                index = (char)(index + '\u0001');
                assert (index != '\u0000') : "Too many multiplicity values";
                ++i;
            }
            assert (index == c);
            int kindIx = kind.ordinal();
            Multiplicity.GLOBAL_MULT_STORE[kindIx] = globalStore;
            Multiplicity.INDEXED_MULT_STORE[kindIx] = indexedStore;
            Multiplicity.OMEGA_MULT_STORE[kindIx] = omegaStore;
            ++n2;
        }
    }

    public static Multiplicity getMultiplicity(int i, int j, MultKind kind) {
        Multiplicity result;
        int kindIx = kind.ordinal();
        if (j == Integer.MAX_VALUE) {
            result = OMEGA_MULT_STORE[kindIx][i];
        } else {
            assert (i <= j && j <= Multiplicity.getBound(kind));
            result = INDEXED_MULT_STORE[kindIx][i][j];
        }
        assert (result != null);
        return result;
    }

    public static Multiplicity getMultiplicity(int index, MultKind kind) {
        return GLOBAL_MULT_STORE[kind.ordinal()][index];
    }

    public static Multiplicity getEdgeSetMult(Set<? extends Edge> edges) {
        int setSize = edges.size();
        return Multiplicity.approx(setSize, setSize, MultKind.EDGE_MULT);
    }

    public static Multiplicity getNodeSetMult(Set<? extends Node> nodes) {
        int setSize = nodes.size();
        return Multiplicity.approx(setSize, setSize, MultKind.NODE_MULT);
    }

    public static int add(int i, int j) {
        assert (Multiplicity.isInNOmega(i) && Multiplicity.isInNOmega(j));
        if (i != Integer.MAX_VALUE && j != Integer.MAX_VALUE) {
            return i + j;
        }
        return Integer.MAX_VALUE;
    }

    public static int sub(int i, int j) {
        assert (Multiplicity.isInNOmega(i) && Multiplicity.isInN(j));
        if (i != Integer.MAX_VALUE) {
            if (j < i) {
                return i - j;
            }
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public static int times(int i, int j) {
        assert (Multiplicity.isInNOmega(i) && Multiplicity.isInNOmega(j));
        if (i == 0 || j == 0) {
            return 0;
        }
        if (i != Integer.MAX_VALUE && j != Integer.MAX_VALUE) {
            return i * j;
        }
        return Integer.MAX_VALUE;
    }

    public static Multiplicity approx(int i, int j, MultKind kind) {
        assert (Multiplicity.isInNOmega(i) && Multiplicity.isInNOmega(j));
        assert (i <= j);
        if (Multiplicity.isUseThreeValues(kind)) {
            return Multiplicity.approxToThreeValues(i, j, kind);
        }
        int b = Multiplicity.getBound(kind);
        if (i > b) {
            i = b + 1;
            j = Integer.MAX_VALUE;
        } else if (j > b) {
            j = Integer.MAX_VALUE;
        }
        return Multiplicity.getMultiplicity(i, j, kind);
    }

    private static Multiplicity approxToThreeValues(int i, int j, MultKind kind) {
        if (i != j || i > 1) {
            i = 0;
            j = Integer.MAX_VALUE;
        }
        return Multiplicity.getMultiplicity(i, j, kind);
    }

    private static boolean isUseThreeValues(MultKind kind) {
        return kind != MultKind.EQSYS_MULT && Multiplicity.getSetAbsParameters().isUseThreeValues();
    }

    public static Multiplicity scale(Multiplicity mult, int factor) {
        assert (factor >= 0);
        return Multiplicity.approx(mult.i * factor, mult.j * factor, mult.kind);
    }

    private Multiplicity(int i, int j, MultKind kind, char index) {
        assert (index >= '\u0000');
        assert (Multiplicity.isInN(i) && Multiplicity.isInNOmega(j));
        assert (i <= j);
        this.i = i;
        this.j = j;
        this.kind = kind;
        this.index = index;
        this.hashCode = super.hashCode();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String result = this.i == this.j ? String.valueOf(this.i) : (this.j == Integer.MAX_VALUE ? String.valueOf(this.i) + "+" : "<" + this.i + "," + this.j + ">");
        return result;
    }

    public String toSerialString() {
        String j = this.j == Integer.MAX_VALUE ? "w" : String.valueOf(this.j);
        return String.valueOf(this.i) + " " + j;
    }

    public int getLowerBound() {
        return this.i;
    }

    public int getUpperBound() {
        return this.j;
    }

    public boolean isZero() {
        return this.i == 0 && this.j == 0;
    }

    public boolean isOne() {
        return this.i == 1 && this.j == 1;
    }

    public boolean isCollector() {
        return this.j > 1;
    }

    public boolean isSingleton() {
        return this.i == this.j;
    }

    public boolean isUnbounded() {
        return this.j == Integer.MAX_VALUE;
    }

    public boolean isZeroPlus() {
        return this.i == 0 && this.j == Integer.MAX_VALUE;
    }

    public boolean isNodeKind() {
        return this.kind == MultKind.NODE_MULT;
    }

    public boolean isEdgeKind() {
        return this.kind == MultKind.EDGE_MULT;
    }

    public Multiplicity add(Multiplicity other) {
        assert (this.kind == other.kind);
        return Multiplicity.approx(Multiplicity.add(this.i, other.i), Multiplicity.add(this.j, other.j), this.kind);
    }

    public Multiplicity sub(int k) {
        assert (Multiplicity.isInN(k));
        return Multiplicity.getMultiplicity(Multiplicity.sub(this.i, k), Multiplicity.sub(this.j, k), this.kind);
    }

    public Multiplicity times(Multiplicity other) {
        assert (this.isNodeKind() && other.isEdgeKind());
        return Multiplicity.getMultiplicity(Multiplicity.times(this.i, other.i), Multiplicity.times(this.j, other.j), MultKind.EQSYS_MULT);
    }

    public boolean le(Multiplicity other) {
        assert (this.kind == other.kind);
        return this.j <= other.j;
    }

    public boolean subsumes(Multiplicity other) {
        assert (this.kind == other.kind);
        return other.i >= this.i && other.j <= this.j;
    }

    public Multiplicity toNodeKind() {
        return Multiplicity.approx(this.i, this.j, MultKind.NODE_MULT);
    }

    public Multiplicity toEdgeKind() {
        return Multiplicity.approx(this.i, this.j, MultKind.EDGE_MULT);
    }

    public MultKind getKind() {
        return this.kind;
    }

    public char getIndex() {
        return this.index;
    }

    public static enum MultKind {
        NODE_MULT,
        EDGE_MULT,
        EQSYS_MULT;

    }
}

