/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.wrapper.JAXJWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;

public class JAXJComboBox
extends JComboBox
implements JAXJWrapper {
    long _eventFilter = Integer.MAX_VALUE;
    boolean _isEditable = true;
    JComponent _nonEditableComponent;
    private MouseListener[] _mouseListeners;
    private int _focusOrder = -1;
    private boolean layingOut = false;

    public JAXJComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.setFont(FontFactory.getComboboxFontDefinition().createFont());
        this.setHorizontalScrollPolicy(30);
    }

    public JAXJComboBox(Object[] items) {
        super(items);
        this.setFont(FontFactory.getComboboxFontDefinition().createFont());
        this.setHorizontalScrollPolicy(30);
    }

    public JAXJComboBox(Vector items) {
        super(items);
        this.setFont(FontFactory.getComboboxFontDefinition().createFont());
        this.setHorizontalScrollPolicy(30);
    }

    public JAXJComboBox() {
        this.setFont(FontFactory.getComboboxFontDefinition().createFont());
        this.setHorizontalScrollPolicy(30);
    }

    public JComponent getNonEditableComponent(Type selected) {
        if (this._nonEditableComponent == null) {
            this._nonEditableComponent = this.createNonEditableEditorComponent(selected);
        }
        return this._nonEditableComponent;
    }

    private JComponent createNonEditableEditorComponent(Type selected) {
        String value = null;
        if (selected.isSimple()) {
            value = ((SimpleType)selected).getValue();
            String defaultValue = ((SimpleType)selected).getDefaultValue();
            if (value != null) {
                String codeValue;
                String codeset;
                if (selected.getXUIDefinition().getStyle().isUsingCodeSet() && (codeset = ((SimpleType)selected).getXUIDefinition().getStyle().getCodeSetName()) != null && value != null && (codeValue = selected.getDOM().getSchema().getCodeTables().getText(selected, codeset, value, selected.getDOM().getLanguage())) != null) {
                    value = codeValue;
                }
                if (defaultValue != null && value.equals(defaultValue)) {
                    String prefix = selected.getDOM().getGlobalDefinition().getDefaultValuePreFix();
                    String postfix = selected.getDOM().getGlobalDefinition().getDefaultValuePostFix();
                    value = prefix + value + postfix;
                }
            }
        } else {
            value = selected.isChoice() && selected.getChoosenType() != null ? selected.getChoosenType().getXUIDefinition().getStyle().getLabelText() : "";
        }
        ImageIcon choiceImage = JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/radioButton_13x13.gif");
        JLabel editor = new JLabel(value, choiceImage, 2);
        editor.setPreferredSize(this.getPreferredSize());
        return editor;
    }

    public void setEditable(boolean editable, boolean allowCellEditing) {
        block4: {
            block5: {
                if (allowCellEditing) {
                    super.setEditable(editable);
                }
                this.setEnabled(editable);
                if (this.getComponent(0) == null) break block4;
                this.getComponent(0).setEnabled(true);
                this.getComponent(0).setFocusable(editable);
                if (this._mouseListeners == null) {
                    this._mouseListeners = this.getComponent(0).getMouseListeners();
                }
                if (editable) break block5;
                for (int a = 0; a < this._mouseListeners.length; ++a) {
                    this.getComponent(0).removeMouseListener(this._mouseListeners[a]);
                }
                break block4;
            }
            if (this.getComponent(0).getMouseListeners().length != 0) break block4;
            for (int a = 0; a < this._mouseListeners.length; ++a) {
                this.getComponent(0).addMouseListener(this._mouseListeners[a]);
            }
        }
    }

    public void release() {
        this._nonEditableComponent = null;
        this._mouseListeners = null;
    }

    public void setHorizontalScrollPolicy(int policy) {
        Component comp;
        BasicComboPopup popup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        if (popup != null && (comp = popup.getComponent(0)) instanceof JScrollPane) {
            JScrollPane scrollpane = (JScrollPane)comp;
            scrollpane.setHorizontalScrollBarPolicy(policy);
        }
    }

    public int getFocusIndex() {
        return this._focusOrder;
    }

    public void setFocusIndex(int index) {
        this._focusOrder = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.getPreferredSize().width);
        }
        return dim;
    }
}

