/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SimpleTypeColorView
extends AbstractSimpleTypeView {
    private ColorPanel _colorPanel;
    private JTextField _textField;
    private JButton _colorButton;
    private JButton _selectButton;
    private JButton _cancelButton;
    private JColorChooser _colorChooser;
    private JPanel _colorPreview;

    public SimpleTypeColorView() {
    }

    public SimpleTypeColorView(Type type) {
        this.setModel(type);
    }

    public SimpleTypeColorView(Type type, Type context) {
        super(context);
        this.setModel(type);
    }

    protected JComponent createEditorComponent() {
        this._editorComponent = new JPanel(new BorderLayout());
        this._textField = new JTextField(this.getModelValue());
        this._textField.setColumns(1);
        this._textField.addActionListener(new ButtonListener());
        this._textField.addFocusListener(this);
        this.setEditorField(this._textField);
        this.setFirstFocusableComponent(this._textField);
        this._colorButton = new JButton("...");
        this._colorButton.addActionListener(new ButtonListener());
        this._colorButton.addFocusListener(this);
        this._editorComponent.add((Component)this._textField, "Center");
        JPanel colorPreviewPanel = new JPanel(new BorderLayout());
        colorPreviewPanel.setPreferredSize(new Dimension(100, 10));
        this._colorPreview = new JPanel();
        colorPreviewPanel.add((Component)this._colorPreview, "Center");
        colorPreviewPanel.add((Component)this._colorButton, "East");
        this._editorComponent.add((Component)colorPreviewPanel, "East");
        return this._editorComponent;
    }

    private Color getColor(String rgbValues) {
        Color color = null;
        try {
            int red = 255;
            int green = 255;
            int blue = 255;
            if (rgbValues != null) {
                StringTokenizer tokenizer = new StringTokenizer(rgbValues, ",");
                if (tokenizer.hasMoreTokens()) {
                    red = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    blue = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    green = Integer.parseInt(tokenizer.nextToken());
                }
            }
            color = red == -1 && green == -1 && blue == -1 ? UIManager.getLookAndFeelDefaults().getColor("Label.background") : new Color(red, blue, green);
        }
        catch (Throwable t) {
            color = Color.black;
        }
        return color;
    }

    public String getText() {
        return this._textField.getText();
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this._textField && !e.isTemporary()) {
            this.populateModel();
            if (this._colorPreview != null) {
                this._colorPreview.setBackground(this.getTypeColor());
                this._colorButton.setBackground(this.getTypeColor());
            }
        }
    }

    private String getModelValue() {
        if (this.getModel() != null) {
            return ((SimpleType)this.getModel()).getValue();
        }
        return "";
    }

    private Color getTypeColor() {
        return this.getColor(this.getModelValue());
    }

    public void populateView() {
        String modelValue = ((SimpleType)this.getModel()).getValue();
        String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
        String xuiDefaultValue = this.getStyle().getLeafDefaultValue();
        if (modelValue == null || modelValue.length() == 0) {
            if (xuiDefaultValue != null && xuiDefaultValue.length() > 0) {
                modelValue = xuiDefaultValue;
            } else if (defaultValue != null && defaultValue.length() > 0) {
                modelValue = defaultValue;
            }
        }
        this._textField.setText(modelValue);
        Color color = this.getColor(modelValue);
        this._colorButton.setBackground(color);
        this._colorPreview.setBackground(color);
    }

    public void release() {
        super.release();
        if (this._textField != null) {
            this._textField.removeFocusListener(this);
        }
        if (this._colorButton != null) {
            this._colorButton.removeFocusListener(this);
        }
        this._colorPanel = null;
        this._textField = null;
        this._colorButton = null;
        this._selectButton = null;
        this._cancelButton = null;
        this._colorChooser = null;
    }

    public class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SimpleTypeColorView.this._colorButton) {
                if (SimpleTypeColorView.this._colorPanel == null) {
                    Component root = SwingUtilities.getRoot(SimpleTypeColorView.this._colorButton);
                    if (root != null) {
                        if (root instanceof Dialog) {
                            SimpleTypeColorView.this._colorPanel = new ColorPanel((Dialog)root);
                        } else if (root instanceof Frame) {
                            SimpleTypeColorView.this._colorPanel = new ColorPanel((Frame)root);
                        }
                    }
                    if (SimpleTypeColorView.this._colorPanel == null) {
                        SimpleTypeColorView.this._colorPanel = new ColorPanel();
                    }
                } else if (!SimpleTypeColorView.this._colorPanel.isVisible()) {
                    Point p = SimpleTypeColorView.this._editorComponent.getLocationOnScreen();
                    SimpleTypeColorView.this._colorPanel.setLocation(p.x, p.y);
                    SimpleTypeColorView.this._colorPanel.setVisible(true);
                } else {
                    SimpleTypeColorView.this._colorPanel.setVisible(false);
                }
            }
            if (e.getSource() == SimpleTypeColorView.this._selectButton) {
                Color currentColor = SimpleTypeColorView.this._colorChooser.getSelectionModel().getSelectedColor();
                String currentValue = "" + currentColor.getRed() + "," + currentColor.getGreen() + "," + currentColor.getBlue();
                SimpleTypeColorView.this._textField.setText(currentValue);
                SimpleTypeColorView.this._colorButton.setBackground(SimpleTypeColorView.this.getColor(currentValue));
                SimpleTypeColorView.this._colorPreview.setBackground(SimpleTypeColorView.this.getColor(currentValue));
                SimpleTypeColorView.this._textField.requestFocus();
                SimpleTypeColorView.this._colorPanel.setVisible(false);
            }
            if (e.getSource() == SimpleTypeColorView.this._cancelButton) {
                SimpleTypeColorView.this._colorPanel.setVisible(false);
            }
            if (e.getSource() == SimpleTypeColorView.this._textField) {
                SimpleTypeColorView.this._colorButton.setBackground(SimpleTypeColorView.this.getColor(SimpleTypeColorView.this._textField.getText()));
                SimpleTypeColorView.this._colorPreview.setBackground(SimpleTypeColorView.this.getColor(SimpleTypeColorView.this._textField.getText()));
            }
        }
    }

    public class ColorPanel
    extends JDialog {
        public ColorPanel() {
            this.init();
        }

        public ColorPanel(Dialog dialog) {
            super(dialog);
            this.init();
        }

        public ColorPanel(Frame frame) {
            super(frame);
            this.init();
        }

        private void init() {
            Container content = this.getContentPane();
            content.setLayout(new BorderLayout());
            JPanel colorPanel = new JPanel();
            JPanel buttonPanel = new JPanel();
            SimpleTypeColorView.this._selectButton = new JButton(GUIComponentNLS.getInstance().getNLSText(SimpleTypeColorView.this.getDOM(), "button_select", "Select"));
            SimpleTypeColorView.this._cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText(SimpleTypeColorView.this.getDOM(), "button_cancel", "Cancel"));
            SimpleTypeColorView.this._selectButton.addActionListener(new ButtonListener());
            SimpleTypeColorView.this._cancelButton.addActionListener(new ButtonListener());
            SimpleTypeColorView.this._colorChooser = new JColorChooser(SimpleTypeColorView.this.getTypeColor());
            SimpleTypeColorView.this._colorChooser.setPreviewPanel(new JPanel());
            colorPanel.add(SimpleTypeColorView.this._colorChooser);
            buttonPanel.add(SimpleTypeColorView.this._selectButton);
            buttonPanel.add(SimpleTypeColorView.this._cancelButton);
            content.add((Component)colorPanel, "North");
            content.add((Component)buttonPanel, "Center");
            Point p = SimpleTypeColorView.this._editorComponent.getLocationOnScreen();
            this.setLocation(p.x, p.y);
            this.setVisible(true);
            this.pack();
            this.validate();
        }
    }
}

