/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.swing.ui.visualizers.JAXFrontCellRenderer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class MultiColumnComboBoxRenderer
extends JPanel
implements JAXFrontCellRenderer {
    private FormulaExpression _formulaExpression;
    private JLabel[] _labels;
    private int _columnCount;
    private ArrayResult _array;
    private String[] _percentage;
    private String _defaultValue = null;
    private String _defaultPrefix = null;
    private String _defaultPostfix = null;

    public MultiColumnComboBoxRenderer(FormulaExpression formulaExpression) {
        this._formulaExpression = formulaExpression;
        this.setOpaque(true);
        this.init();
    }

    public MultiColumnComboBoxRenderer(ArrayResult arrayResult) {
        this(arrayResult, null);
    }

    public MultiColumnComboBoxRenderer(ArrayResult arrayResult, String[] percentage) {
        this._array = arrayResult;
        this._percentage = percentage;
        this.setOpaque(true);
        this.init();
    }

    private void init() {
        this._columnCount = 0;
        if (this._array == null) {
            try {
                this._columnCount = ((List)this._formulaExpression.evaluateObject()).size();
            }
            catch (FormulaException ex) {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "Unable to figure out column count from array expression: " + this._formulaExpression.getExpression());
                }
            }
        } else if (this._array.get(0) instanceof List) {
            this._columnCount = ((List)this._array.get(0)).size();
        }
        this._labels = new JLabel[this._columnCount];
        String formLayoutDefinition = "";
        int percentageColumnWidth = 100 / this._columnCount;
        for (int i = 0; i < this._columnCount; ++i) {
            if (this._percentage != null && this._percentage.length >= i) {
                percentageColumnWidth = Integer.valueOf(this._percentage[i]);
            }
            formLayoutDefinition = formLayoutDefinition + "left:0:grow(0." + percentageColumnWidth + ")";
            if (i != this._columnCount) {
                formLayoutDefinition = formLayoutDefinition + ",";
            }
            this._labels[i] = new JLabel();
        }
        this.setLayout(new FormLayout(formLayoutDefinition, "pref"));
        CellConstraints cc = new CellConstraints();
        for (int i = 1; i <= this._columnCount; ++i) {
            this.add((Component)this._labels[i - 1], cc.xy(i, 1));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        block14: {
            if (index != -1 && (value instanceof Type || value instanceof String)) {
                try {
                    String text = " ";
                    List arrayResult = null;
                    if (value instanceof Type) {
                        Type type = (Type)value;
                        if (!type.isEmpty()) {
                            if (this._formulaExpression != null) {
                                this._formulaExpression.setSource(type);
                                arrayResult = (List)this._formulaExpression.evaluateObject();
                            }
                        } else {
                            arrayResult = new ArrayResult();
                            arrayResult.add(" ");
                            arrayResult.add(" ");
                        }
                    } else {
                        arrayResult = (List)this._array.elementAt(index);
                    }
                    if (this._columnCount == arrayResult.size()) {
                        Object result = null;
                        for (int i = 0; i < this._columnCount; ++i) {
                            result = arrayResult.get(i);
                            if (result instanceof String) {
                                text = result;
                            }
                            text = SimpleType.createVisibleDefaultValue((String)text, (String)this.getDefaultValue(), (String)text, (String)this.getDefaultPrefix(), (String)this.getDefaultPostfix());
                            this._labels[i].setText(text);
                            if (isSelected) {
                                this._labels[i].setBackground(list.getSelectionBackground());
                                this._labels[i].setForeground(list.getSelectionForeground());
                                continue;
                            }
                            this._labels[i].setBackground(list.getBackground());
                            this._labels[i].setForeground(list.getForeground());
                        }
                    }
                }
                catch (FormulaException ex) {
                    if (!LogRegistry.getInstance().logWarnings()) break block14;
                    LogRegistry.getInstance().warn(this.getClass(), "Error while perform array formula (" + this._formulaExpression.getExpression() + ")");
                }
            }
        }
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : new EmptyBorder(1, 1, 1, 1));
        return this;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public void setDefaultPostfix(String postfix) {
        this._defaultPostfix = postfix;
    }

    public void setDefaultPrefix(String prefix) {
        this._defaultPrefix = prefix;
    }

    public String getDefaultPostfix() {
        return this._defaultPostfix;
    }

    public String getDefaultPrefix() {
        return this._defaultPrefix;
    }
}

