/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.error.Error;
import com.jaxfront.core.error.ValidationError;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.KeyRefCellRenderer;
import com.jaxfront.swing.ui.visualizers.TypeXPathListCellRenderer;
import com.jaxfront.swing.ui.wrapper.JAXJList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KeyRefRelationView
extends JPanel
implements ListSelectionListener,
Visualizer,
SimpleTypeVisualizer,
MouseListener {
    private Type _keyType = null;
    private Vector _allRefs = null;
    private JDialog _dialog = null;
    private JAXJList _list = null;
    private JComponent _focusComp = null;

    public KeyRefRelationView(Type key) {
        this._keyType = key;
        this.build();
    }

    private void build() {
        List containers = this._keyType.getDOM().getKeyKeyRefManager().getKeyContainer((SimpleType)this._keyType, this._keyType.getSchemaElement().getSchemaKeys());
        for (int c = 0; c < containers.size(); ++c) {
            KeyContainer kc = (KeyContainer)containers.get(c);
            this._allRefs = kc.getAllReferencesFor(((SimpleType)this._keyType).getPlainValue());
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel(this._keyType.getDisplayValue()), "Center");
            JButton button = new JButton();
            if (this._allRefs.size() >= 1) {
                if (this._allRefs.size() > 1) {
                    this._list = new JAXJList(this._allRefs);
                    this._list.addMouseListener(this);
                    KeyRefCellRenderer renderer = new KeyRefCellRenderer(this._keyType);
                    this._list.setCellRenderer(renderer);
                    button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/showList_16x16.gif"));
                    String buttonTooltip = GUIComponentNLS.getInstance().getNLSText(this._keyType.getDOM(), "show_KeyReferences", "show all references");
                    button.setToolTipText(buttonTooltip);
                    button.addActionListener(new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            KeyRefRelationView.this.showDialog();
                        }
                    });
                    this._focusComp = this._list;
                } else {
                    button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/jump_Back12x16.gif"));
                    String buttonTooltip = GUIComponentNLS.getInstance().getNLSText(this._keyType.getDOM(), "jumpTo_KeyReference", "jump to reference");
                    button.setToolTipText(buttonTooltip);
                    button.addActionListener(new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            KeyRefRelationView.this.jumpTo();
                        }
                    });
                    this._focusComp = button;
                }
                this.add((Component)button, "East");
                continue;
            }
            this._focusComp = this;
        }
    }

    public void jumpTo() {
        FocusHelper.focus((Type)this._allRefs.get(0));
    }

    private void showDialog() {
        String dialogTitle = GUIComponentNLS.getInstance().getNLSText(this._keyType.getDOM(), "key_references", "Key references");
        this._dialog = GUITools.createDialogFor(this, true, dialogTitle);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JScrollPane(this._list), "Center");
        this._dialog.getContentPane().add(p);
        this._dialog.setSize(300, 200);
        this._dialog.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JAXJList) {
            JAXJList sourceList = (JAXJList)e.getSource();
            Type sType = (Type)sourceList.getSelectedValue();
            FocusHelper.focus(sType);
            if (this._dialog != null) {
                this._dialog.setVisible(false);
            }
        }
    }

    public Type getContext() {
        return null;
    }

    public void setContext(Type type) {
    }

    public Visualizer getImplementation() {
        return null;
    }

    public String getLabelText() {
        return null;
    }

    public Type getModel() {
        return this._keyType;
    }

    public String getText() {
        return this._keyType.getDisplayValue();
    }

    public void markError() {
    }

    public void populateModel() {
    }

    public void populateView() {
    }

    public void postInitialization() {
    }

    public void release() {
    }

    public void removeLabel() {
    }

    public void resetError() {
    }

    public void setApplicationRequired(boolean required) {
    }

    public void setEditable(boolean enabled) {
    }

    public void setLabelColor(Color color) {
    }

    public void setLabelText(String text) {
    }

    public void setModel(Type type) {
        this._keyType = type;
    }

    public void setRequired(boolean required) {
    }

    public void showLabel(boolean show) {
    }

    public JComponent getEditorField() {
        return this._focusComp;
    }

    public static void handleDeleteError(Exception e, Document dom) {
        String dialogTitle = GUIComponentNLS.getInstance().getNLSText(dom, "dialog_deletion_confirmation", "Delete Selected Item");
        if (e.getCause() instanceof KeyRefException) {
            KeyRefException keyRefEx = (KeyRefException)e.getCause();
            if (keyRefEx.getReferences() != null) {
                final JAXJList refList = new JAXJList(keyRefEx.getReferences());
                refList.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() >= 2 && e.getSource() == refList) {
                            JAXJList sourceList = (JAXJList)e.getSource();
                            Type sType = (Type)sourceList.getSelectedValue();
                            FocusHelper.focus(sType);
                        }
                    }
                });
                refList.setCellRenderer(new TypeXPathListCellRenderer());
                JScrollPane scroller = new JScrollPane(refList, 20, 32);
                scroller.setPreferredSize(new Dimension(300, 100));
                JOptionPane.showMessageDialog(dom.getEditor().getWindow(), scroller, "Key has open references to:", 0);
            }
        } else if (e.getCause() instanceof ValidationException) {
            ValidationException ve = (ValidationException)e.getCause();
            ve.getSource().getDOM().getController().getErrorController().addError((Error)new ValidationError(ve, ve.getSource()));
        } else {
            JOptionPane.showMessageDialog(dom.getEditor().getWindow(), e.getMessage(), dialogTitle, 0);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2 && e.getSource() == this._list) {
            JAXJList sourceList = (JAXJList)e.getSource();
            Type sType = (Type)sourceList.getSelectedValue();
            FocusHelper.focus(sType);
            if (this._dialog != null) {
                this._dialog.setVisible(false);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean isViewReleased() {
        return false;
    }

    public JComponent getEditorComponent() {
        return this.getEditorField();
    }

    public int getRendererType() {
        return 1;
    }
}

