/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.search.AbstractSearcher;
import com.jaxfront.core.util.search.SearchComparator;
import com.jaxfront.core.util.search.SearchResultProcessor;
import com.jaxfront.core.util.stringSearch.StringSearch;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TextComponentSearcher
extends AbstractSearcher
implements SearchResultProcessor {
    private JTextComponent textComponent;
    private Position searchStartPosition;
    private boolean searchWrap;
    String _replaceText = null;

    public TextComponentSearcher(JTextComponent textComponent) {
        this.setTextComponent(textComponent);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public void doFindNext(String find, boolean down) {
        String searchInText = this.getSearchInText();
        if (!this._matchCase) {
            searchInText = searchInText.toLowerCase();
            find = find.toLowerCase();
        }
        this.processFindNext(find, down, searchInText);
    }

    public String getReplaceString() {
        return this._replaceText;
    }

    protected String getSelectedText() {
        return this.getTextComponent().getSelectedText();
    }

    protected void setSelectionEnd(int offset) {
        this.getTextComponent().setSelectionEnd(offset);
    }

    protected int getSelectionStart() {
        return this.getTextComponent().getSelectionStart();
    }

    protected int getSelectionEnd() {
        return this.getTextComponent().getSelectionEnd();
    }

    private boolean processFindNext(String find, boolean searchDown, String searchInText) {
        int result;
        String needle = find;
        String haystack = searchInText;
        int offset = this.getSelectionStart();
        String selectedText = this.getSelectedText();
        this.setSelectionEnd(offset);
        if (needle.equalsIgnoreCase(selectedText)) {
            offset = searchDown ? ++offset : --offset;
        }
        if ((result = this.searchFor(needle, haystack, offset, searchDown)) == -1) {
            this.resetSearchVariables();
            return false;
        }
        this.setSelectionStart(result);
        this.setSelectionEnd(result + needle.length());
        return true;
    }

    protected void setSelectionStart(int start) {
        this.getTextComponent().setSelectionStart(start);
    }

    protected int searchFor(String needle, String haystack, int offset, boolean searchDown) {
        int result;
        int wrapSearchOffset;
        if (searchDown) {
            wrapSearchOffset = 0;
            result = haystack.indexOf(needle, offset);
        } else {
            wrapSearchOffset = haystack.length();
            result = haystack.lastIndexOf(needle, offset);
        }
        if (result == -1) {
            if (this.searchWrap) {
                return result;
            }
            this.searchWrap = true;
            return this.searchFor(needle, haystack, wrapSearchOffset, searchDown);
        }
        int wrapResult = searchDown ? result - this.searchStartPosition.getOffset() : this.searchStartPosition.getOffset() - result - 1;
        if (this.searchWrap && wrapResult >= 0) {
            return -1;
        }
        if (this._matchWord && !this.isWord(haystack, result, needle.length())) {
            if (searchDown) {
                return this.searchFor(needle, haystack, result + 1, searchDown);
            }
            return this.searchFor(needle, haystack, result - 1, searchDown);
        }
        return result;
    }

    private boolean isWord(String haystack, int offset, int length) {
        int leftSide = offset - 1;
        int rightSide = offset + length;
        return this.isDelimiter(haystack, leftSide) && this.isDelimiter(haystack, rightSide);
    }

    private boolean isDelimiter(String haystack, int offset) {
        if (offset < 0 || offset > haystack.length()) {
            return true;
        }
        return !Character.isLetterOrDigit(haystack.charAt(offset));
    }

    private boolean processReplace(String find, String replace, boolean down) {
        String needle = find;
        String replaceText = replace;
        String selectedText = this.getSelectedText();
        String searchInText = this.getSearchInText();
        if (!this._matchCase) {
            searchInText = searchInText.toLowerCase();
            find = find.toLowerCase();
        }
        if (this._matchCase && needle.equals(selectedText)) {
            this.replaceSelection(replaceText);
        }
        if (!this._matchCase && needle.equalsIgnoreCase(selectedText)) {
            this.replaceSelection(replaceText);
        }
        return this.processFindNext(find, down, searchInText);
    }

    protected void replaceSelection(String replaceText) {
        this.getTextComponent().replaceSelection(replaceText);
    }

    private void processReplaceAll(String find, String replace) {
        JViewport viewport = null;
        Point point = null;
        this.resetSearchVariables();
        Container c = this.getParentContainer();
        if (c instanceof JViewport) {
            viewport = (JViewport)c;
            point = viewport.getViewPosition();
        }
        while (this.processReplace(find, replace, true)) {
        }
        if (c instanceof JViewport) {
            viewport.setViewPosition(point);
        }
    }

    protected Container getParentContainer() {
        return this.getTextComponent().getParent();
    }

    protected void setTextComponent(JTextComponent textComponent) {
        if (this.textComponent != textComponent) {
            this.textComponent = textComponent;
            this.resetSearchVariables();
        }
    }

    protected void resetSearchVariables() {
        try {
            this.searchWrap = false;
            if (this.textComponent != null) {
                this.searchStartPosition = this.textComponent.getDocument().createPosition(this.textComponent.getSelectionStart());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean search(String value) {
        this.setSearchValue(value);
        return true;
    }

    public Object getPrevious() {
        String searchInText = this.getSearchInText();
        String find = this.getSearchValue();
        if (!this._matchCase) {
            searchInText = searchInText.toLowerCase();
            find = find.toLowerCase();
        }
        this.processFindNext(find, false, searchInText);
        return this.getSelectionStart() + "-" + this.getSelectionEnd();
    }

    protected String getSearchInText() {
        return this.textComponent.getText();
    }

    public Object getNext() {
        boolean hasResult;
        String searchInText = this.getSearchInText();
        String find = this.getSearchValue();
        if (!this._matchCase) {
            searchInText = searchInText.toLowerCase();
            find = find.toLowerCase();
        }
        if (hasResult = this.processFindNext(find, true, searchInText)) {
            return "Line " + this.getLineAtCaret(this.textComponent) + ":" + this.getSelectionStart() + "-" + this.getSelectionEnd();
        }
        return null;
    }

    public int getLineAtCaret(JTextComponent component) {
        int caretPosition = this.textComponent.getCaretPosition();
        Element root = component.getDocument().getDefaultRootElement();
        return root.getElementIndex(caretPosition);
    }

    public void reset() {
        this.resetSearchVariables();
    }

    public List getAll() {
        int oldStart = this.getSelectionStart();
        int oldEnd = this.getSelectionEnd();
        this.setSelectionStart(0);
        this.reset();
        String searchInText = this.getSearchInText();
        String findString = this.getSearchValue();
        if (!this._matchCase) {
            searchInText = searchInText.toLowerCase();
            findString = findString.toLowerCase();
        }
        Vector<String> result = new Vector<String>();
        ArrayList results = StringSearch.getAllOccurences((String)searchInText, (String)findString, (boolean)this._matchCase, (boolean)this._isRegEx);
        for (int r = 0; r < results.size(); ++r) {
            Integer start = (Integer)results.get(r);
            int newLines = TextTools.countCharBetween((String)searchInText, (int)0, (int)start, (char)StringUtil.newLine.charAt(0), (char)'U');
            int iStart = start - newLines;
            int iEnd = iStart + findString.length();
            result.add("Line " + newLines + ":" + iStart + "-" + iEnd);
        }
        this.selectText(oldStart, oldEnd);
        return result;
    }

    protected void selectText(int from, int to) {
        this.textComponent.select(from, to);
    }

    public void process(Object aResult) {
        if (aResult != null) {
            String selection = aResult.toString();
            int lineSepIndex = selection.indexOf(58) + 1;
            int sepIndex = selection.indexOf(45);
            String from = selection.substring(lineSepIndex, sepIndex);
            String to = selection.substring(sepIndex + 1, selection.length());
            this.selectText(Integer.parseInt(from), Integer.parseInt(to));
        }
    }

    public void replaceNext(Object what, Object with) {
        this.processReplace(what.toString(), with.toString(), true);
    }

    public void replacePrevious(Object what, Object with) {
        this.processReplace(what.toString(), with.toString(), false);
    }

    public void replaceAll(Object what, Object with) {
        this.processReplaceAll(what.toString(), with.toString());
    }

    public void setComparator(SearchComparator comparator) {
    }
}

