/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.util.PrintfFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;

public class ResultTreeNodeCellRenderer
extends DefaultListCellRenderer {
    private PrintfFormat typePrintFormat = new PrintfFormat("Name: %-16.16s XPath: %-16.16s");

    public ResultTreeNodeCellRenderer() {
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setFont(new Font("Dialog", 0, 13));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && value instanceof TreeNode) {
            TreeNode node = (TreeNode)value;
            if (node.getUserObject() != null && node.getUserObject() instanceof Type) {
                Type aType = (Type)node.getUserObject();
                this.setText(this.typePrintFormat.sprintf(new Object[]{aType.getName(), aType.getXPathLocation()}));
            } else {
                this.setText(node.toString());
            }
        } else {
            this.setText(value == null ? "" : value.toString());
        }
        this.setBackground(isSelected ? Color.red : Color.white);
        this.setForeground(isSelected ? Color.white : Color.black);
        return this;
    }
}

