/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class SimpleHTMLBrowser
extends JComponent
implements ActionListener,
HyperlinkListener,
FocusListener {
    private JPanel topPanel;
    private JButton homeButton;
    private JTextField urlField;
    private JLabel urlLabel;
    private JEditorPane htmlPane;
    private URL initialURL;
    private String htmContent;
    private JScrollPane scrollPane;
    private boolean useURLTextfield;
    SimpleHTMLBrowser _sharedInstance;

    public SimpleHTMLBrowser(URL initialURL, boolean useURLTextfield) {
        this.useURLTextfield = useURLTextfield;
        this.initialURL = initialURL;
        this.htmContent = null;
        this.initLayout();
        this.setPage(initialURL);
    }

    public SimpleHTMLBrowser(String initialHtmlContent, boolean useURLTextfield) {
        this.useURLTextfield = useURLTextfield;
        this.initialURL = null;
        this.htmContent = initialHtmlContent;
        this.initLayout();
        this.setText(this.htmContent);
    }

    public SimpleHTMLBrowser(boolean useURLTextfield) {
        this("", useURLTextfield);
    }

    public SimpleHTMLBrowser() {
        this("", false);
    }

    SimpleHTMLBrowser getSharedInstance() {
        if (this._sharedInstance == null) {
            this._sharedInstance = new SimpleHTMLBrowser();
        }
        return this._sharedInstance;
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.homeButton = new JButton("Home");
        this.homeButton.addActionListener(this);
        this.urlLabel = new JLabel("URL:");
        this.urlField = new JTextField(30);
        this.urlField.addFocusListener(this);
        if (this.useURLTextfield) {
            this.topPanel.add(this.homeButton);
            this.topPanel.add(this.urlField);
            this.topPanel.add(this.urlLabel);
        }
        this.add((Component)this.topPanel, "North");
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.htmlPane);
        this.add((Component)this.scrollPane, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.homeButton) {
            if (this.initialURL == null) {
                this.setText(this.htmContent);
            } else {
                this.setPage(this.initialURL);
            }
        }
    }

    public void removeUrlTextFields() {
        this.topPanel.remove(this.homeButton);
        this.topPanel.remove(this.urlField);
        this.topPanel.remove(this.urlLabel);
    }

    public void addUrlTextFields() {
        if (this.useURLTextfield) {
            this.topPanel.add(this.homeButton);
            this.topPanel.add(this.urlField);
            this.topPanel.add(this.urlLabel);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(event.getURL());
        }
    }

    public void setPage(String newURLAdress) {
        try {
            URL newAdress = new URL(newURLAdress);
            this.setPage(newAdress);
        }
        catch (MalformedURLException ioe) {
            this.warnUser("Malformed URL: " + newURLAdress + ": \n" + ioe);
        }
    }

    public void setPage(URL newAdress) {
        try {
            this.htmlPane.setPage(newAdress);
            this.urlField.setText(newAdress.toExternalForm());
        }
        catch (IOException ioe) {
            this.warnUser("Can't follow link to " + newAdress.toExternalForm() + ": \n" + ioe);
        }
    }

    public void setText(String htmlText) {
        this.htmlPane.setDocument(new HTMLEditorKit().createDefaultDocument());
        this.htmContent = htmlText;
        this.htmlPane.getDocument().putProperty("stream", null);
        this.htmlPane.setText(htmlText);
        this.htmlPane.setCaretPosition(0);
        this.urlField.setText("");
    }

    public String getText() {
        return this.htmlPane.getText();
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public static void main(String[] args) throws IOException {
        SimpleHTMLBrowser browser = null;
        browser = args.length == 0 ? new SimpleHTMLBrowser(new URL("file:/C:/WINNT/Profiles/srzwih/workspace/MyTest/src/docs/test/JavaDoc.html"), false) : new SimpleHTMLBrowser(args[0], false);
        JFrame frame = new JFrame("test");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)browser, "Center");
        frame.setSize(new Dimension(600, 800));
        frame.show();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.urlField) {
            String url = this.urlField.getText();
            if (!url.startsWith("http://")) {
                url = "http://" + url;
            }
            if (this.htmlPane.getPage() == null || !this.htmlPane.getPage().toExternalForm().equals(url)) {
                this.setPage(url);
            }
        }
    }

    public Object clone() {
        URL url = this.htmlPane.getPage();
        String content = this.htmlPane.getText();
        SimpleHTMLBrowser clone = null;
        clone = url != null ? new SimpleHTMLBrowser(url, this.useURLTextfield) : new SimpleHTMLBrowser(content, this.useURLTextfield);
        return clone;
    }
}

