/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;

public class ImageTools
extends Component {
    public static final int MERGE_MODE_HORIZONTAL = 1;
    public static final int MERGE_MODE_VERTICAL = 2;
    public static final int MERGE_MODE_MELT = 3;
    private static final byte[] NULL_IMAGE_DEF = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static ImageTools _instance;

    private ImageTools() {
    }

    public static ImageTools getInstance() {
        if (_instance == null) {
            _instance = new ImageTools();
        }
        return _instance;
    }

    public static Image merge(Image i1, Image i2, ImageObserver observer, Color background, boolean horizontal, boolean vertical) {
        int w = 0;
        int h = 0;
        int x2 = 0;
        int y2 = 0;
        if (i1 == null && i2 != null) {
            return i2;
        }
        if (i1 != null && i2 == null) {
            return i1;
        }
        if (horizontal) {
            w = i1.getWidth(observer) + i2.getWidth(observer);
            h = i1.getHeight(observer) > i2.getHeight(observer) ? i1.getHeight(observer) : i2.getHeight(observer);
            x2 = i1.getWidth(observer);
        } else if (vertical) {
            w = i1.getWidth(observer) > i2.getWidth(observer) ? i1.getWidth(observer) : i2.getWidth(observer);
            h = i1.getHeight(observer) + i2.getHeight(observer);
            y2 = i1.getHeight(observer);
        } else {
            w = i1.getWidth(observer) > i2.getWidth(observer) ? i1.getWidth(observer) : i2.getWidth(observer);
            h = i1.getHeight(observer) > i2.getHeight(observer) ? i1.getHeight(observer) : i2.getHeight(observer);
        }
        BufferedImage myImage = new BufferedImage(w, h, 1);
        ImageTools.fill(myImage, background);
        Graphics2D g2 = myImage.createGraphics();
        g2.drawImage(i1, 0, 0, observer);
        g2.drawImage(i2, x2, y2, observer);
        return myImage;
    }

    public static Image merge(Image i1, Image i2, ImageObserver observer, Color background, int mode) {
        int w = 0;
        int h = 0;
        int x2 = 0;
        int y2 = 0;
        if (i1 == null && i2 != null) {
            return i2;
        }
        if (i1 != null && i2 == null) {
            return i1;
        }
        switch (mode) {
            case 1: {
                w = i1.getWidth(observer) + i2.getWidth(observer);
                h = i1.getHeight(observer) > i2.getHeight(observer) ? i1.getHeight(observer) : i2.getHeight(observer);
                x2 = i1.getWidth(observer);
                break;
            }
            case 2: {
                w = i1.getWidth(observer) > i2.getWidth(observer) ? i1.getWidth(observer) : i2.getWidth(observer);
                h = i1.getHeight(observer) + i2.getHeight(observer);
                y2 = i1.getHeight(observer);
                break;
            }
            case 3: {
                w = i1.getWidth(observer) > i2.getWidth(observer) ? i1.getWidth(observer) : i2.getWidth(observer);
                h = i1.getHeight(observer) > i2.getHeight(observer) ? i1.getHeight(observer) : i2.getHeight(observer);
                break;
            }
            default: {
                w = i1.getWidth(observer) + i2.getWidth(observer);
                h = i1.getHeight(observer) > i2.getHeight(observer) ? i1.getHeight(observer) : i2.getHeight(observer);
                x2 = i1.getWidth(observer);
            }
        }
        BufferedImage myImage = new BufferedImage(w, h, 1);
        ImageTools.fill(myImage, background);
        Graphics2D g2 = myImage.createGraphics();
        g2.drawImage(i1, 0, 0, observer);
        g2.drawImage(i2, x2, y2, observer);
        return myImage;
    }

    public static void makeTransparent(BufferedImage bImage, Color color) {
        int markColor = color.getRGB() | 0xFF000000;
        for (int y = 0; y < bImage.getHeight(); ++y) {
            for (int x = 0; x < bImage.getWidth(); ++x) {
                int col = bImage.getRGB(x, y);
                if ((col | 0xFF000000) != markColor) continue;
                bImage.setRGB(x, y, 0xFFFFFF & col);
            }
        }
    }

    public static void clear(BufferedImage bImage) {
        for (int y = 0; y < bImage.getHeight(); ++y) {
            for (int x = 0; x < bImage.getWidth(); ++x) {
                bImage.setRGB(x, y, 0xFFFFFF);
            }
        }
    }

    public static void fill(BufferedImage bImage, Color color) {
        if (color != null) {
            for (int y = 0; y < bImage.getHeight(); ++y) {
                for (int x = 0; x < bImage.getWidth(); ++x) {
                    bImage.setRGB(x, y, color.getRGB());
                }
            }
        }
    }

    public static ImageIcon merge(ImageIcon ii1, ImageIcon ii2, ImageObserver observer, Color background, int mode) {
        if (ii1 == null && ii2 != null) {
            return ii2;
        }
        if (ii1 != null && ii2 == null) {
            return ii1;
        }
        Image i1 = ii1.getImage();
        Image i2 = ii2.getImage();
        return new ImageIcon(ImageTools.merge(i1, i2, observer, background, mode));
    }

    public static ImageIcon merge(ImageIcon ii1, ImageIcon ii2, ImageObserver observer, Color background, boolean horizontal, boolean vertical) {
        if (ii1 == null && ii2 != null) {
            return ii2;
        }
        if (ii1 != null && ii2 == null) {
            return ii1;
        }
        Image i1 = ii1.getImage();
        Image i2 = ii2.getImage();
        return new ImageIcon(ImageTools.merge(i1, i2, observer, background, horizontal, vertical));
    }

    public static void main(String[] args) {
    }

    public static ImageIcon createEmptyImageIcon() {
        return new ImageIcon(NULL_IMAGE_DEF);
    }

    public static Image createEmptyImage() {
        return ImageTools.createEmptyImageIcon().getImage();
    }

    public static Image changeBrightness(Image aImage, int brightness) {
        ImageTools imageTools = ImageTools.getInstance();
        ImageProducer imageProducer = aImage.getSource();
        ImageTools imageTools2 = ImageTools.getInstance();
        imageTools2.getClass();
        return imageTools.createImage(new FilteredImageSource(imageProducer, imageTools2.new BrightnessImageFilter(brightness)));
    }

    public static void saveComponentAsJPEG(Component myComponent, String filename) {
        BufferedImage myImage = ImageTools.createImageFromComponent(myComponent);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(myImage);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static BufferedImage createImageFromComponent(Component myComponent) {
        Dimension size = myComponent.getSize();
        return ImageTools.createImageFromComponent(myComponent, size.width, size.height);
    }

    public static BufferedImage createImageFromComponent(Component myComponent, int width, int height) {
        BufferedImage myImage = new BufferedImage(width, height, 1);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paintAll(g2);
        return myImage;
    }

    public static BufferedImage createOfflineImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public static BufferedImage createStringImage(String text, int width, int height, Font font, Color fontColor, Color background) {
        BufferedImage myImage = ImageTools.createOfflineImage(width, height);
        ImageTools.fill(myImage, background);
        Graphics2D g2 = myImage.createGraphics();
        g2.setColor(fontColor != null ? fontColor : Color.black);
        g2.drawString(text, 5, 5);
        return myImage;
    }

    class RedBlueSwapFilter
    extends RGBImageFilter {
        public RedBlueSwapFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return rgb & 0xFF00FF00 | (rgb & 0xFF0000) >> 16 | (rgb & 0xFF) << 16;
        }
    }

    public class BrightnessImageFilter
    extends RGBImageFilter {
        int percent;

        public BrightnessImageFilter(int pct) {
            this.canFilterIndexColorModel = true;
            this.percent = pct;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            r = Math.min(255, r * this.percent / 100);
            g = Math.min(255, g * this.percent / 100);
            b = Math.min(255, b * this.percent / 100);
            return (rgb & 0xFF000000) + (r << 16) + (g << 8) + b;
        }
    }
}

