/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.GenericAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class FlipPanel
extends JPanel {
    private boolean _flipped = false;
    private GridBagConstraints _constraints;
    private Component _content;
    private Component _flippedContent;

    public FlipPanel() {
        this.setLayout(new GridBagLayout());
        this._constraints = new GridBagConstraints();
    }

    public FlipPanel(Component content) {
        this();
        this._content = content;
        this.flip();
    }

    public FlipPanel(Component content, Component flippedContent) {
        this(content);
        this.setFlippedContent(flippedContent);
    }

    public boolean isFlipped() {
        return this._flipped;
    }

    public Component getContent() {
        return this._content;
    }

    public void setContent(Component newContent) {
        this._content = newContent;
        this.flip();
    }

    public void flip() {
        this.setVisible(false);
        this.removeAll();
        this._constraints.gridx = -1;
        this._constraints.gridy = 0;
        this._constraints.gridheight = 0;
        this._constraints.gridwidth = 0;
        this._constraints.weightx = 1.0;
        this._constraints.weighty = 1.0;
        this._constraints.anchor = 17;
        this._constraints.fill = 1;
        if (this._flipped) {
            this.add(this.getFlippedContent(), this._constraints);
        } else {
            this.add(this.getContent(), this._constraints);
        }
        this._flipped = !this._flipped;
        this.revalidate();
        this.setVisible(true);
    }

    public static BorderActionSet getExpandCollapseBorderSet(Object controller) {
        return new BorderActionSet("collapse", new GenericAction("collapse", controller, "collapse"), new GenericAction("expand", controller, "expand"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif").getImage(), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif").getImage(), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif").getImage(), null, "bubbleHelpText", 0);
    }

    public void setFlippedContent(Component flippedContent) {
        this._flippedContent = flippedContent;
    }

    public Component getFlippedContent() {
        if (this._flippedContent == null) {
            this._flippedContent = new JPanel();
        }
        return this._flippedContent;
    }
}

