/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.layout;

import com.jaxfront.swing.ui.tools.GUITools;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class TabActionIcon
implements Icon {
    private ImageIcon _mIcon;
    private ImageIcon _inverseIcon;
    private JTabbedPane _mTabbedPane = null;
    private transient Rectangle _mPosition = null;
    private Action _action;
    private Action _inverseAction;
    private boolean _toggled = false;
    private boolean _pressed = false;
    private boolean _paintZero = true;
    private boolean _dynamicMode = false;
    private int _tabIndex = -1;
    public static final String TAB_INDEX = "tabIndex";
    public static final int P_XOFFSET = 2;
    public static final int P_YOFFSET = 2;

    public TabActionIcon(ImageIcon icon) {
        this._mIcon = icon;
    }

    public TabActionIcon(Action action, Action inverseAction) {
        this.setAction(action);
        this.setInverseAction(inverseAction);
    }

    public TabActionIcon(Action action) {
        this.setAction(action);
    }

    public TabActionIcon(ImageIcon icon, ImageIcon inverseIcon) {
        this._mIcon = icon;
        this._inverseIcon = inverseIcon;
    }

    public TabActionIcon() {
        this(new ImageIcon(TabActionIcon.class.getResource("icons/closeTab.gif")));
    }

    private Action getActiveAction() {
        if (this._toggled) {
            if (this.getInverseAction() != null) {
                return this.getInverseAction();
            }
            return this.getAction();
        }
        return this.getAction();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (null == this._mTabbedPane) {
            this._mTabbedPane = (JTabbedPane)c;
            if (this._mTabbedPane.getSelectedIndex() == this._tabIndex) {
                this._paintZero = false;
                this._mTabbedPane.repaint();
            }
            this._mTabbedPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!e.isConsumed() && TabActionIcon.this._mPosition.contains(e.getX(), e.getY())) {
                        TabActionIcon.this._pressed = true;
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    TabActionIcon.this._pressed = false;
                    if (!e.isConsumed() && TabActionIcon.this._mPosition.contains(e.getX(), e.getY()) && TabActionIcon.this.getActiveAction().isEnabled()) {
                        if (TabActionIcon.this._inverseIcon != null) {
                            TabActionIcon.this._toggled = !TabActionIcon.this._toggled;
                        }
                        TabActionIcon.this.getActiveAction().actionPerformed(new ActionEvent(this, 1001, "perform"));
                        TabActionIcon.this._mTabbedPane.repaint();
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    if (TabActionIcon.this.isDynamicMode() && e.getSource() == TabActionIcon.this._mTabbedPane) {
                        TabActionIcon.this._paintZero = false;
                        TabActionIcon.this._mTabbedPane.repaint();
                    }
                }

                public void mouseExited(MouseEvent e) {
                    TabActionIcon.this._pressed = false;
                    TabActionIcon.this._paintZero = true;
                    TabActionIcon.this._mTabbedPane.repaint();
                }
            });
        }
        this._mPosition = new Rectangle(x, y, this.getIconWidth(), this.getIconHeight());
        if (this.getActiveAction().isEnabled()) {
            this.paintActionIcon(c, g, x, y, this.getActiveIcon());
        } else {
            new ImageIcon(GrayFilter.createDisabledImage(this._mIcon.getImage())).paintIcon(c, g, x, y);
        }
    }

    private void paintActionIcon(Component c, Graphics g, int x, int y, ImageIcon icon) {
        if (this._pressed) {
            this.getActiveIcon().paintIcon(c, g, x + 2, y + 2);
        } else {
            this.getActiveIcon().paintIcon(c, g, x, y);
        }
    }

    public ImageIcon getActiveIcon() {
        if (this.isDynamicMode() && this._paintZero) {
            return GUITools.EMPTY_ICON;
        }
        if (this._toggled && this._inverseIcon != null) {
            return this._inverseIcon;
        }
        return this._mIcon;
    }

    public int getIconWidth() {
        return this.getActiveIcon().getIconWidth();
    }

    public int getIconHeight() {
        return this.getActiveIcon().getIconHeight();
    }

    public void setAction(Action action) {
        this._action = action;
        ImageIcon aIcon = (ImageIcon)action.getValue("SmallIcon");
        Integer index = (Integer)action.getValue(TAB_INDEX);
        if (index != null) {
            this._tabIndex = index;
        }
        if (aIcon != null) {
            this._mIcon = aIcon;
        }
    }

    public Action getAction() {
        return this._action;
    }

    public void setInverseAction(Action inverseAction) {
        ImageIcon aIcon;
        this._inverseAction = inverseAction;
        if (inverseAction != null && (aIcon = (ImageIcon)inverseAction.getValue("SmallIcon")) != null) {
            this._inverseIcon = aIcon;
        }
    }

    public Action getInverseAction() {
        return this._inverseAction;
    }

    public void setTabIndex(int index) {
        this._tabIndex = index;
    }

    public void setDynamicMode(boolean dynamicMode) {
        this._dynamicMode = dynamicMode;
    }

    public boolean isDynamicMode() {
        return this._dynamicMode;
    }
}

