/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class TypeTable
extends JTable
implements MouseListener {
    private final int COLUMN_COUNT = 2;
    private String[] columnNames = new String[2];
    private Document _dom;
    private Type[] _types;
    private int _lastRowIndex = -1;
    private AbstractTableModel tableModel = new AbstractTableModel(){

        public Object getValueAt(int row, int col) {
            if (TypeTable.this._types != null && row >= 0 && row <= TypeTable.this._types.length) {
                if (TypeTable.this._types[row].getSchemaElement() == null) {
                    return null;
                }
                try {
                    switch (col) {
                        case 0: {
                            return TypeTable.this._types[row];
                        }
                        case 1: {
                            return TypeTable.this._types[row];
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return null;
        }

        public int getRowCount() {
            if (TypeTable.this._types != null) {
                return TypeTable.this._types.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return TypeTable.this.columnNames[columnIndex];
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    };

    public TypeTable(Document dom, String[] typeXPaths) {
        this._dom = dom;
        this.initTypes(typeXPaths);
        this.addMouseListener(this);
        this.setFocusable(false);
        this.columnNames[0] = GUIComponentNLS.getInstance().getNLSText(this._dom, "message_table_description", "Description");
        this.columnNames[1] = GUIComponentNLS.getInstance().getNLSText(this._dom, "message_table_context", "Navigation Tree Context");
        this.initGUI();
    }

    private void initTypes(String[] typeXPaths) {
        Vector found = new Vector();
        List tempFound = null;
        for (int i = 0; i < typeXPaths.length; ++i) {
            tempFound = DOMHelper.getLockedTypes((Type)this._dom.getRootType(), (String)typeXPaths[i]);
            if (tempFound.size() > 0) {
                found.addAll(tempFound);
                continue;
            }
            if (!LogRegistry.getInstance().logWarnings()) continue;
            LogRegistry.getInstance().warn(this.getClass(), "Unable to find type for xpath: " + typeXPaths[i]);
        }
        this._types = new Type[found.size()];
        found.toArray(this._types);
    }

    public void updateTable() {
        if (this._types != null && this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        if (this._types == null) {
            this.updateUI();
        }
    }

    private void initGUI() {
        this.setModel(this.tableModel);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().getColumn(0).setCellRenderer(new TypeTableCellRenderer());
        this.getColumnModel().getColumn(0).setMinWidth(180);
        this.getColumnModel().getColumn(1).setCellRenderer(new TypeTableCellRenderer());
        this.getColumnModel().getColumn(1).setMinWidth(300);
        this.getSelectionModel().addListSelectionListener(this);
    }

    private void focusError() {
        int rowIndex = this.getSelectionModel().getLeadSelectionIndex();
        if (this._types != null && rowIndex != -1 && this._types.length > rowIndex) {
            AbstractView view;
            Type type = this._types[rowIndex];
            boolean isNewError = true;
            if (rowIndex == this._lastRowIndex && type != null && (view = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(type)).getFirstFocusableComponent() != null && view.getFirstFocusableComponent().hasFocus()) {
                isNewError = false;
            }
            if (isNewError) {
                FocusHelper.focus(type);
                this._lastRowIndex = rowIndex;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
        if (!event.getValueIsAdjusting()) {
            DefaultListSelectionModel model = (DefaultListSelectionModel)event.getSource();
            if (model.isSelectionEmpty()) {
                return;
            }
            int rowIndex = this.getSelectionModel().getLeadSelectionIndex();
            if (rowIndex != this._lastRowIndex) {
                this.focusError();
            }
        }
    }

    public void release() {
        this.removeMouseListener(this);
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().removeListSelectionListener(this);
        }
        this._types = null;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            this.focusError();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public class TypeTableCellRenderer
    extends DefaultTableCellRenderer {
        private JTextArea _textArea = new JTextArea();
        private UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        private Color selectionBackground = this.defaults.getColor("Table.selectionBackground");
        private Color selectionForeground = this.defaults.getColor("Table.selectionForeground");
        private Color background = this.defaults.getColor("Table.background");
        private Color foreground = this.defaults.getColor("Table.foreground");

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (isSelected) {
                this._textArea.setBackground(this.selectionBackground);
                this._textArea.setForeground(this.selectionForeground);
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else {
                this._textArea.setBackground(this.background);
                this._textArea.setForeground(this.foreground);
                this.setBackground(this.background);
                this.setForeground(this.foreground);
            }
            if (value != null) {
                try {
                    if ((vColIndex == 0 || vColIndex == 1) && value instanceof Type) {
                        String messageClassification = null;
                        ImageIcon icon = null;
                        Type type = (Type)value;
                        if (vColIndex == 0) {
                            if (type.isSimple()) {
                                messageClassification = type.getXUIDefinition().getStyle().getLabelText();
                            } else {
                                if (type.getXUIDefinition().getStyle().hasCaption()) {
                                    messageClassification = type.getXUIDefinition().getStyle().getCaptionTitleLabel();
                                }
                                if (type.isRepresentedAsTreeNode()) {
                                    messageClassification = type.getXUIDefinition().getStyle().getTreeLabelText();
                                }
                            }
                        } else {
                            messageClassification = ((Type)value).getShortCaption();
                            icon = ((Type)value).getRepresentedTreeNodeParentIcon();
                        }
                        this.setText(messageClassification);
                        this.setIcon(icon);
                        this.setToolTipText(messageClassification);
                        this.setHorizontalAlignment(2);
                        this.setFont(this.defaults.getFont("Table.font"));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

