/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public abstract class AbstractJFlexCTokenMaker
extends AbstractJFlexTokenMaker {
    protected static final Action INSERT_BREAK_ACTION = new InsertBreakAction();

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return true;
    }

    public Action getInsertBreakAction() {
        return INSERT_BREAK_ACTION;
    }

    public boolean getShouldIndentNextLineAfter(Token token) {
        if (token != null && token.textCount == 1) {
            char c = token.text[token.textOffset];
            return c == '{' || c == '(';
        }
        return false;
    }

    private static class InsertBreakAction
    extends RSyntaxTextAreaEditorKit.InsertBreakAction {
        private static final Pattern p = Pattern.compile("([ \\t]*)(/?[\\*]+)([ \\t]*)");

        private InsertBreakAction() {
        }

        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n;
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getTextComponent(actionEvent);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            int n2 = rSyntaxDocument.getLastTokenTypeOnLine(n = rTextArea.getCaretLineNumber());
            if (n2 == 3 || n2 == 2) {
                this.insertBreakInMLC(actionEvent, rSyntaxTextArea, n);
            } else {
                this.handleInsertBreak(rSyntaxTextArea, true);
            }
        }

        private boolean appearsNested(RSyntaxTextArea rSyntaxTextArea, int n, int n2) {
            int n3 = n;
            while (n < rSyntaxTextArea.getLineCount()) {
                Token token = rSyntaxTextArea.getTokenListForLine(n);
                int n4 = 0;
                if (n++ == n3) {
                    if ((token = RSyntaxUtilities.getTokenAtOffset(token, n2)) == null) continue;
                    n4 = token.documentToToken(n2);
                } else {
                    n4 = token.textOffset;
                }
                while (n4 < token.textOffset + token.textCount - 1) {
                    if (token.text[n4] == '/' && token.text[n4 + 1] == '*') {
                        return true;
                    }
                    ++n4;
                }
                if (token.getNextToken() == null) continue;
                return false;
            }
            return true;
        }

        private void insertBreakInMLC(ActionEvent actionEvent, RSyntaxTextArea rSyntaxTextArea, int n) {
            String string;
            Matcher matcher = null;
            int n2 = -1;
            int n3 = -1;
            try {
                n2 = rSyntaxTextArea.getLineStartOffset(n);
                n3 = rSyntaxTextArea.getLineEndOffset(n);
                string = rSyntaxTextArea.getText(n2, n3 - n2);
                matcher = p.matcher(string);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
                badLocationException.printStackTrace();
                return;
            }
            if (matcher.lookingAt()) {
                string = matcher.group(1);
                String string2 = matcher.group(2);
                int n4 = rSyntaxTextArea.getCaretPosition();
                if (n4 >= n2 && n4 < n2 + string.length() + string2.length()) {
                    if (string2.charAt(0) == '/') {
                        this.handleInsertBreak(rSyntaxTextArea, true);
                        return;
                    }
                    rSyntaxTextArea.setCaretPosition(n3 - 1);
                }
                boolean bl = string2.charAt(0) == '/';
                boolean bl2 = this.appearsNested(rSyntaxTextArea, n, n2 + string.length() + 2);
                String string3 = string + (bl ? " * " : "*") + matcher.group(3);
                rSyntaxTextArea.replaceSelection("\n" + string3);
                if (bl2) {
                    n4 = rSyntaxTextArea.getCaretPosition();
                    rSyntaxTextArea.insert("\n" + string + " */", n4);
                    rSyntaxTextArea.setCaretPosition(n4);
                }
            } else {
                this.handleInsertBreak(rSyntaxTextArea, true);
            }
        }
    }
}

