/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.trans.Automaton;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeSet;

public class Node<PropT>
implements Comparable<Node<PropT>> {
    private int accepting_conds = 0;
    private boolean init_collapsed = false;
    private int nodeId;
    private TreeSet<Node<PropT>> incoming;
    private TreeSet<Formula<PropT>> toBeDone;
    private TreeSet<Formula<PropT>> old;
    private TreeSet<Formula<PropT>> next;
    private BitSet accepting;
    private BitSet right_of_untils;
    private Node<PropT> OtherTransitionSource;
    private int equivalenceId;
    private Pool pool;

    Node(Pool pool, int accepting_conds) {
        this.pool = pool;
        this.accepting_conds = accepting_conds;
        this.nodeId = pool.requestId();
        this.incoming = new TreeSet();
        this.toBeDone = new TreeSet();
        this.old = new TreeSet();
        this.next = new TreeSet();
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.right_of_untils = new BitSet(accepting_conds);
    }

    Node(Pool pool, int accepting_conds, TreeSet<Node<PropT>> in, TreeSet<Formula<PropT>> newForm, TreeSet<Formula<PropT>> done, TreeSet<Formula<PropT>> nx, BitSet acc, BitSet rous) {
        this.pool = pool;
        this.accepting_conds = accepting_conds;
        this.nodeId = pool.requestId();
        this.incoming = new TreeSet<Node<PropT>>(in);
        this.toBeDone = new TreeSet<Formula<PropT>>(newForm);
        this.old = new TreeSet<Formula<PropT>>(done);
        this.next = new TreeSet<Formula<PropT>>(nx);
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.accepting.or(acc);
        this.right_of_untils = new BitSet(accepting_conds);
        this.right_of_untils.or(rous);
    }

    public int getAcceptingConds() {
        return this.accepting_conds;
    }

    public static <PropT> Node<PropT> createInitial(Formula<PropT> form, Pool pool) {
        int accepting_conds = form.initialize();
        Node<PropT> init = new Node<PropT>(pool, accepting_conds);
        assert (init.nodeId == 0);
        if (form.getContent() != Formula.Content.TRUE) {
            init.decompose_ands_for_next(form);
        }
        return init;
    }

    public TreeSet<Formula<PropT>> getField_next() {
        return this.next;
    }

    public TreeSet<Formula<PropT>> getField_old() {
        return this.old;
    }

    public int getId() {
        return this.nodeId;
    }

    public boolean isInitial() {
        return this.nodeId == 0;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void RTstructure(State<PropT>[] RTautomaton) {
        boolean safety = false;
        if (RTautomaton[this.nodeId] == null) {
            RTautomaton[this.nodeId] = new State(this.accepting, this.equivalenceId);
        } else {
            RTautomaton[this.nodeId].updateAcc(this.accepting, this.equivalenceId);
        }
        if (this.is_safety_acc_node()) {
            RTautomaton[this.nodeId].updateSafetyAcc(true);
            safety = true;
        }
        Node<PropT> Alternative = this;
        while (Alternative != null) {
            for (Node<PropT> nextNode : Alternative.incoming) {
                int stateId = nextNode.getId();
                if (RTautomaton[stateId] == null) {
                    RTautomaton[stateId] = new State();
                }
                RTautomaton[stateId].add(new Transition<PropT>(Alternative.old, this.equivalenceId, this.accepting, safety, this.accepting_conds));
            }
            Alternative = Alternative.OtherTransitionSource;
        }
    }

    @Override
    public int compareTo(Node<PropT> f) {
        if (this == f) {
            return 0;
        }
        return 1;
    }

    public boolean compare_accepting(Node<PropT> nd) {
        if (this.nodeId == 0 && !this.init_collapsed) {
            return true;
        }
        return this.accepting.equals(nd.accepting);
    }

    public void debug() {
        System.out.println("debugging now");
        for (Formula<PropT> nextForm : this.old) {
            System.out.println("Content is " + (Object)((Object)nextForm.getContent()));
        }
    }

    public void decompose_ands_for_next(Formula<PropT> form) {
        if (form.getContent() == Formula.Content.AND) {
            this.decompose_ands_for_next(form.getSub1());
            this.decompose_ands_for_next(form.getSub2());
        } else if (!Node.is_redundant(this.next, null, form)) {
            this.next.add(form);
        }
    }

    public Automaton<PropT> expand(Automaton<PropT> states) {
        if (this.toBeDone.isEmpty()) {
            Node<PropT> tempNode;
            if (this.nodeId != 0) {
                this.update_accepting();
            }
            if ((tempNode = states.alreadyThere(this)) != null) {
                super.modify(this);
                return states;
            }
            Node<PropT> NewN = new Node<PropT>(this.pool, this.accepting_conds);
            NewN.incoming.add(this);
            NewN.toBeDone.addAll(this.next);
            states.add(this);
            return NewN.expand(states);
        }
        Formula<PropT> ita = this.toBeDone.first();
        this.toBeDone.remove(ita);
        if (this.testForContradictions(ita)) {
            return states;
        }
        if (ita.is_right_of_until(this.accepting_conds)) {
            this.right_of_untils.or(ita.get_rightOfWhichUntils());
        }
        TreeSet<Formula<PropT>> set_checked_against = new TreeSet<Formula<PropT>>();
        set_checked_against.addAll(this.old);
        set_checked_against.addAll(this.toBeDone);
        if (Node.is_redundant(set_checked_against, this.next, ita)) {
            return this.expand(states);
        }
        if (ita.getContent() == Formula.Content.UNTIL) {
            this.accepting.set(ita.get_untils_index());
        }
        if (!ita.isLiteral()) {
            switch (ita.getContent()) {
                case OR: 
                case UNTIL: 
                case RELEASE: 
                case WEAK_UNTIL: {
                    Node<PropT> node2 = this.split(ita);
                    return node2.expand(this.expand(states));
                }
                case NEXT: {
                    this.decompose_ands_for_next(ita.getSub1());
                    return this.expand(states);
                }
                case AND: {
                    Formula<PropT> temp_form = ita.getSub1();
                    if (!this.old.contains(temp_form)) {
                        this.toBeDone.add(temp_form);
                    }
                    if (!this.old.contains(temp_form = ita.getSub2())) {
                        this.toBeDone.add(temp_form);
                    }
                    return this.expand(states);
                }
            }
            System.out.println("default case of switch entered");
            return null;
        }
        if (ita.getContent() != Formula.Content.TRUE) {
            this.old.add(ita);
        }
        return this.expand(states);
    }

    public int get_equivalenceId() {
        return this.equivalenceId;
    }

    public void set_equivalenceId(int value) {
        this.equivalenceId = value;
    }

    public void update_accepting() {
        this.accepting.andNot(this.right_of_untils);
    }

    private static <PropT> boolean is_redundant(TreeSet<Formula<PropT>> main_set, TreeSet<Formula<PropT>> next_set, Formula<PropT> ita) {
        return ita.is_special_case_of_V(main_set) || ita.is_synt_implied(main_set, next_set) && (ita.getContent() != Formula.Content.UNTIL || ita.getSub2().is_synt_implied(main_set, next_set));
    }

    private boolean is_safety_acc_node() {
        if (this.next.isEmpty()) {
            return true;
        }
        Iterator<Formula<PropT>> iterNext = this.next.iterator();
        Formula<PropT> nextForm = null;
        while (iterNext.hasNext()) {
            nextForm = iterNext.next();
            if (nextForm.getContent() == Formula.Content.RELEASE || nextForm.getContent() == Formula.Content.WEAK_UNTIL) continue;
            return false;
        }
        return true;
    }

    private void modify(Node<PropT> current) {
        boolean match = false;
        Node<PropT> Tail = this;
        Node<PropT> Alternative = this;
        if (this.nodeId == 0 && !this.init_collapsed) {
            this.accepting = current.accepting;
            this.init_collapsed = true;
        }
        while (Alternative != null) {
            if (Alternative.old.equals(current.old)) {
                Alternative.incoming.addAll(current.incoming);
                match = true;
            }
            Tail = Alternative;
            Alternative = Alternative.OtherTransitionSource;
        }
        if (!match) {
            Tail.OtherTransitionSource = current;
        }
    }

    private Node<PropT> split(Formula<PropT> form) {
        Node<PropT> Node2 = new Node<PropT>(this.pool, this.accepting_conds, this.incoming, this.toBeDone, this.old, this.next, this.accepting, this.right_of_untils);
        Formula<PropT> temp_form = form.getSub2();
        if (!this.old.contains(temp_form)) {
            Node2.toBeDone.add(temp_form);
        }
        if (form.getContent() == Formula.Content.RELEASE && !this.old.contains(temp_form = form.getSub1())) {
            Node2.toBeDone.add(temp_form);
        }
        if (!this.old.contains(temp_form = form.getSub1())) {
            this.toBeDone.add(temp_form);
        }
        if ((temp_form = form.getNext()) != null) {
            this.decompose_ands_for_next(temp_form);
        }
        if (form.isLiteral()) {
            this.old.add(form);
            System.out.println("added " + form);
            Node2.old.add(form);
        }
        return Node2;
    }

    private boolean testForContradictions(Formula<PropT> ita) {
        Formula<PropT> Not_ita = ita.negate();
        return Not_ita.is_synt_implied(this.old, this.next);
    }
}

