/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import java.util.BitSet;
import java.util.HashMap;
import java.util.TreeSet;

public class Formula<PropT>
implements Comparable<Formula<PropT>> {
    private static int nId = 0;
    private static HashMap<Formula<?>, Formula<?>> cache = new HashMap();
    private Content content;
    private Formula<PropT> left;
    private Formula<PropT> right;
    private int id = nId++;
    private int untils_index;
    private BitSet rightOfWhichUntils;
    private PropT name;
    private boolean has_been_visited;
    private int hash = 0;

    private Formula(Content c, Formula<PropT> sx, Formula<PropT> dx, PropT n) {
        this.content = c;
        this.left = sx;
        this.right = dx;
        this.name = n;
        this.rightOfWhichUntils = null;
        this.untils_index = -1;
        this.has_been_visited = false;
    }

    public static void resetStatic() {
        cache = new HashMap();
    }

    public Content getContent() {
        return this.content;
    }

    public PropT getName() {
        return this.name;
    }

    Formula<PropT> getNext() {
        switch (this.content) {
            case UNTIL: 
            case RELEASE: 
            case WEAK_UNTIL: {
                return this;
            }
        }
        return null;
    }

    public Formula<PropT> getSub1() {
        if (this.content == Content.RELEASE) {
            return this.right;
        }
        return this.left;
    }

    public Formula<PropT> getSub2() {
        if (this.content == Content.RELEASE) {
            return this.left;
        }
        return this.right;
    }

    void addLeft(Formula<PropT> l) {
        assert (this.content != Content.PROPOSITION) : "formula is an atom";
        this.left = l;
        this.hash = 0;
    }

    void addRight(Formula<PropT> r) {
        switch (this.content) {
            case AND: 
            case OR: 
            case UNTIL: 
            case RELEASE: 
            case WEAK_UNTIL: {
                break;
            }
            default: {
                assert (false) : "operator " + (Object)((Object)this.content) + " is not binary";
                break;
            }
        }
        this.right = r;
        this.hash = 0;
    }

    @Override
    public int compareTo(Formula<PropT> f) {
        return this.id - f.id;
    }

    int countUntils(int acc_sets) {
        this.has_been_visited = true;
        if (this.getContent() == Content.UNTIL) {
            ++acc_sets;
        }
        if (this.left != null && !this.left.has_been_visited) {
            acc_sets = this.left.countUntils(acc_sets);
        }
        if (this.right != null && !this.right.has_been_visited) {
            acc_sets = this.right.countUntils(acc_sets);
        }
        return acc_sets;
    }

    BitSet get_rightOfWhichUntils() {
        return this.rightOfWhichUntils;
    }

    int get_untils_index() {
        return this.untils_index;
    }

    int initialize() {
        int acc_sets = this.countUntils(0);
        this.reset_visited();
        this.processRightUntils(0, acc_sets);
        this.reset_visited();
        return acc_sets;
    }

    public boolean isLiteral() {
        switch (this.content) {
            case PROPOSITION: 
            case TRUE: 
            case FALSE: {
                return true;
            }
            case NOT: {
                return this.getSub1().content == Content.PROPOSITION;
            }
        }
        return false;
    }

    boolean is_right_of_until(int size) {
        return this.rightOfWhichUntils != null;
    }

    boolean is_special_case_of_V(TreeSet<Formula<PropT>> check_against) {
        Formula<PropT> tmp = Formula.False();
        Formula<PropT> form = Formula.Release(tmp, this);
        return check_against.contains(form);
    }

    boolean is_synt_implied(TreeSet<Formula<PropT>> old, TreeSet<Formula<PropT>> next) {
        if (this.getContent() == Content.TRUE) {
            return true;
        }
        if (old.contains(this)) {
            return true;
        }
        if (this.isLiteral()) {
            return false;
        }
        Formula<PropT> form1 = this.getSub1();
        Formula<PropT> form2 = this.getSub2();
        Formula<PropT> form3 = this.getNext();
        boolean condition1 = true;
        boolean condition2 = true;
        boolean condition3 = true;
        if (form2 != null) {
            condition2 = form2.is_synt_implied(old, next);
        }
        if (form1 != null) {
            condition1 = form1.is_synt_implied(old, next);
        }
        if (form3 != null) {
            condition3 = next != null ? next.contains(form3) : false;
        }
        switch (this.getContent()) {
            case OR: 
            case UNTIL: 
            case WEAK_UNTIL: {
                return condition2 || condition1 && condition3;
            }
            case RELEASE: {
                return condition1 && condition2 || condition1 && condition3;
            }
            case NEXT: {
                if (form1 != null) {
                    if (next != null) {
                        return next.contains(form1);
                    }
                    return false;
                }
                return true;
            }
            case AND: {
                return condition2 && condition1;
            }
        }
        System.out.println("Default case of switch at Form.synt_implied");
        return false;
    }

    public Formula<PropT> negate() {
        return Formula.Not(this);
    }

    int processRightUntils(int current_index, int acc_sets) {
        this.has_been_visited = true;
        if (this.getContent() == Content.UNTIL) {
            this.untils_index = current_index;
            if (this.right.rightOfWhichUntils == null) {
                this.right.rightOfWhichUntils = new BitSet(acc_sets);
            }
            this.right.rightOfWhichUntils.set(current_index);
            ++current_index;
        }
        if (this.left != null && !this.left.has_been_visited) {
            current_index = this.left.processRightUntils(current_index, acc_sets);
        }
        if (this.right != null && !this.right.has_been_visited) {
            current_index = this.right.processRightUntils(current_index, acc_sets);
        }
        return current_index;
    }

    void reset_visited() {
        this.has_been_visited = false;
        if (this.left != null) {
            this.left.reset_visited();
        }
        if (this.right != null) {
            this.right.reset_visited();
        }
    }

    public int size() {
        switch (this.content) {
            case AND: 
            case OR: 
            case UNTIL: 
            case RELEASE: 
            case WEAK_UNTIL: {
                return this.left.size() + this.right.size() + 1;
            }
            case NOT: 
            case NEXT: {
                return this.left.size() + 1;
            }
            case PROPOSITION: 
            case TRUE: 
            case FALSE: {
                return 1;
            }
        }
        return 0;
    }

    public String toString(boolean exprId) {
        String idTag = exprId ? "[" + this.id + "]" : "";
        String conn = null;
        String r = null;
        switch (this.content) {
            case AND: {
                conn = "/\\";
            }
            case OR: {
                if (conn == null) {
                    conn = "\\/";
                }
            }
            case UNTIL: {
                if (conn == null) {
                    conn = "U";
                }
            }
            case RELEASE: {
                if (conn == null) {
                    conn = "V";
                }
            }
            case WEAK_UNTIL: {
                if (conn == null) {
                    conn = "W";
                }
                r = "( " + this.left.toString(exprId) + " " + conn + " " + this.right.toString(exprId) + " )";
                break;
            }
            case NEXT: {
                conn = "X";
            }
            case NOT: {
                if (conn == null) {
                    conn = "!";
                }
                r = "( " + conn + " " + this.left.toString(exprId) + " )";
                break;
            }
            case TRUE: {
                conn = "true";
            }
            case FALSE: {
                if (conn == null) {
                    conn = "false";
                }
            }
            case PROPOSITION: {
                if (conn == null) {
                    conn = this.name.toString();
                }
            }
            default: {
                if (conn == null) {
                    conn = this.content.toString();
                }
                r = "( " + conn + " )";
            }
        }
        return String.valueOf(r) + idTag;
    }

    public String toString() {
        return this.toString(false);
    }

    public static <PropT> Formula<PropT> Always(Formula<PropT> f) {
        Formula<PropT> tmp = Formula.False();
        return Formula.unique(new Formula<Object>(Content.RELEASE, tmp, f, null));
    }

    public static <PropT> Formula<PropT> And(Formula<PropT> sx, Formula<PropT> dx) {
        if (sx.id < dx.id) {
            return Formula.unique(new Formula<Object>(Content.AND, sx, dx, null));
        }
        return Formula.unique(new Formula<Object>(Content.AND, dx, sx, null));
    }

    public static <PropT> Formula<PropT> Eventually(Formula<PropT> f) {
        Formula<PropT> tmp = Formula.True();
        return Formula.unique(new Formula<Object>(Content.UNTIL, tmp, f, null));
    }

    public static <PropT> Formula<PropT> False() {
        return Formula.unique(new Formula<Object>(Content.FALSE, null, null, null));
    }

    public static <PropT> Formula<PropT> Implies(Formula<PropT> sx, Formula<PropT> dx) {
        return Formula.Or(Formula.Not(sx), dx);
    }

    public static <PropT> Formula<PropT> Next(Formula<PropT> f) {
        return Formula.unique(new Formula<Object>(Content.NEXT, f, null, null));
    }

    public static <PropT> Formula<PropT> Not(Formula<PropT> f) {
        if (f.isLiteral()) {
            switch (f.content) {
                case TRUE: {
                    return Formula.False();
                }
                case FALSE: {
                    return Formula.True();
                }
                case NOT: {
                    return f.left;
                }
            }
            return Formula.unique(new Formula<Object>(Content.NOT, f, null, null));
        }
        switch (f.content) {
            case AND: {
                return Formula.Or(Formula.Not(f.left), Formula.Not(f.right));
            }
            case OR: {
                return Formula.And(Formula.Not(f.left), Formula.Not(f.right));
            }
            case UNTIL: {
                return Formula.Release(Formula.Not(f.left), Formula.Not(f.right));
            }
            case RELEASE: {
                return Formula.Until(Formula.Not(f.left), Formula.Not(f.right));
            }
            case WEAK_UNTIL: {
                return Formula.WRelease(Formula.Not(f.left), Formula.Not(f.right));
            }
            case NOT: {
                return f.left;
            }
            case NEXT: {
                return Formula.Next(Formula.Not(f.left));
            }
        }
        assert (false) : "found literal with is_literal() false";
        return null;
    }

    public static <PropT> Formula<PropT> Or(Formula<PropT> sx, Formula<PropT> dx) {
        if (sx.id < dx.id) {
            return Formula.unique(new Formula<Object>(Content.OR, sx, dx, null));
        }
        return Formula.unique(new Formula<Object>(Content.OR, dx, sx, null));
    }

    public static <PropT> Formula<PropT> Proposition(PropT name) {
        return Formula.unique(new Formula<PropT>(Content.PROPOSITION, null, null, name));
    }

    public static <PropT> Formula<PropT> Release(Formula<PropT> sx, Formula<PropT> dx) {
        return Formula.unique(new Formula<Object>(Content.RELEASE, sx, dx, null));
    }

    public static <PropT> Formula<PropT> True() {
        return Formula.unique(new Formula<Object>(Content.TRUE, null, null, null));
    }

    public static <PropT> Formula<PropT> Until(Formula<PropT> sx, Formula<PropT> dx) {
        return Formula.unique(new Formula<Object>(Content.UNTIL, sx, dx, null));
    }

    public static <PropT> Formula<PropT> WRelease(Formula<PropT> sx, Formula<PropT> dx) {
        return Formula.unique(new Formula<Object>(Content.UNTIL, dx, Formula.And(sx, dx), null));
    }

    public static <PropT> Formula<PropT> WUntil(Formula<PropT> sx, Formula<PropT> dx) {
        return Formula.unique(new Formula<Object>(Content.WEAK_UNTIL, sx, dx, null));
    }

    private static <PropT> Formula<PropT> unique(Formula<PropT> f) {
        if (cache.containsKey(f)) {
            return cache.get(f);
        }
        cache.put(f, f);
        return f;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Formula)) {
            return false;
        }
        Formula f = (Formula)obj;
        switch (this.content) {
            case PROPOSITION: {
                return this.name.equals(f.name);
            }
            case AND: 
            case OR: 
            case UNTIL: 
            case RELEASE: 
            case WEAK_UNTIL: {
                return f.content == this.content && this.left.equals(f.left) && this.right.equals(f.right);
            }
            case NOT: 
            case NEXT: {
                return f.content == this.content && this.left.equals(f.left);
            }
            case TRUE: 
            case FALSE: {
                return f.content == this.content;
            }
        }
        assert (false) : "unknown operator";
        return false;
    }

    int getId() {
        return this.id;
    }

    public int hashCode() {
        int l = 0;
        int r = 0;
        if (this.hash != 0) {
            return this.hash;
        }
        int me = this.content != Content.PROPOSITION ? this.content.hashCode() : this.name.hashCode();
        if (this.left != null) {
            l = this.left.hashCode();
        }
        if (this.right != null) {
            r = this.right.hashCode();
        }
        this.hash = me ^ ~l ^ r;
        return this.hash;
    }

    public static enum Content {
        PROPOSITION('p'),
        AND('A'),
        OR('O'),
        UNTIL('U'),
        RELEASE('V'),
        WEAK_UNTIL('W'),
        NOT('N'),
        NEXT('X'),
        TRUE('t'),
        FALSE('f');

        private final char c;

        private Content(char c) {
            this.c = c;
        }

        public String toString() {
            return "" + this.c;
        }
    }
}

