/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.trans.Node;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Translator;
import java.util.LinkedList;

class Automaton<PropT> {
    private LinkedList<Node<PropT>> nodeList = new LinkedList();
    private Node<PropT>[] equivalence_classes = null;
    private Pool pool;

    Automaton(Pool pool) {
        this.pool = pool;
    }

    public Graph<PropT> SMoutput(State<PropT>[] automaton) {
        Graph g = new Graph();
        g.setStringAttribute("type", "gba");
        g.setStringAttribute("ac", "edges");
        if (automaton == null) {
            return g;
        }
        int size = this.pool.getIdCount();
        gov.nasa.ltl.graph.Node[] nodes = new gov.nasa.ltl.graph.Node[size];
        int i = 0;
        while (i < size) {
            if (automaton[i] != null && i == automaton[i].getRepresentativeId()) {
                nodes[i] = new gov.nasa.ltl.graph.Node(g);
                nodes[i].setStringAttribute("label", "S" + automaton[i].getRepresentativeId());
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (automaton[i] != null && i == automaton[i].getRepresentativeId()) {
                automaton[i].SMoutput(nodes, nodes[i]);
            }
            ++i;
        }
        assert (this.nodeList.size() > 0);
        int accepting_conds = this.nodeList.get(0).getAcceptingConds();
        if (accepting_conds == 0) {
            g.setIntAttribute("nsets", 1);
        } else {
            g.setIntAttribute("nsets", accepting_conds);
        }
        return g;
    }

    public void add(Node<PropT> nd) {
        this.nodeList.add(nd);
    }

    public Node<PropT> alreadyThere(Node<PropT> nd) {
        for (Node node : this.nodeList) {
            if (!node.getField_next().equals(nd.getField_next()) || !node.compare_accepting(nd) || Translator.getAlgorithm() != Translator.Algorithm.LTL2BUCHI && !node.getField_old().equals(nd.getField_old())) continue;
            return node;
        }
        return null;
    }

    public int index_equivalence(Node<PropT> nd) {
        int index = 0;
        while (index <= this.pool.lastId()) {
            if (this.equivalence_classes[index] == null) break;
            if (Translator.getAlgorithm() == Translator.Algorithm.LTL2BUCHI && this.equivalence_classes[index].getField_next().equals(nd.getField_next())) {
                return this.equivalence_classes[index].getNodeId();
            }
            ++index;
        }
        assert (index <= this.pool.lastId()) : "ERROR - size of equivalence classes array was incorrect";
        this.equivalence_classes[index] = nd;
        return this.equivalence_classes[index].getNodeId();
    }

    public State<PropT>[] structForRuntAnalysis() {
        this.pool.stop();
        int automatonSize = this.pool.getIdCount();
        State[] RTstruct = new State[automatonSize];
        this.equivalence_classes = new Node[automatonSize];
        for (Node node : this.nodeList) {
            node.set_equivalenceId(this.index_equivalence(node));
            node.RTstructure(RTstruct);
        }
        return RTstruct;
    }
}

