/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.tests;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.Visitor;
import gov.nasa.ltl.graphio.Reader;
import gov.nasa.ltl.graphio.Writer;
import java.io.IOException;

public class SM2Dot {
    public static void endDigraph() {
        System.out.println("}");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage:");
            System.err.println("\tSM2Dot <filename>");
            System.err.println();
            System.exit(1);
        }
        try {
            Graph<String> g = Reader.read(args[0]);
            SM2Dot.startDigraph(args[0]);
            SM2Dot.printInit(g.getInit());
            g.forAllNodes((Visitor<String>)new EmptyVisitor<String>(){

                @Override
                public void visitNode(Node<String> n) {
                    SM2Dot.printNode(n);
                    n.forAllEdges((Visitor<String>)new EmptyVisitor<String>(){

                        @Override
                        public void visitEdge(Edge<String> e) {
                            SM2Dot.printEdge(e);
                        }
                    });
                }
            });
            SM2Dot.endDigraph();
        }
        catch (IOException e) {
            System.err.println("Can't load file: " + args[0]);
            System.exit(1);
        }
    }

    public static void printEdge(Edge<String> e) {
        int id = e.getSource().getId();
        int nxt = e.getNext().getId();
        String guard = Writer.formatSMGuard(e.getGuard());
        String action = e.getAction();
        String label = e.getStringAttribute("label");
        StringBuilder sb = new StringBuilder();
        sb.append('\t').append(id).append(" -> ").append(nxt).append(" [label=\"");
        if (label != null) {
            sb.append(label);
            sb.append("\\n");
        }
        if (!guard.equals("-")) {
            sb.append(guard);
            if (!action.equals("-")) {
                sb.append('/').append(action).append("\\n");
            } else {
                sb.append("\\n");
            }
        } else if (!action.equals("-")) {
            sb.append(guard).append('/').append(action).append("\\n");
        } else {
            sb.append("true\\n");
        }
        int nsets = e.getSource().getGraph().getIntAttribute("nsets");
        boolean first = true;
        int i = 0;
        while (i < nsets) {
            if (e.getBooleanAttribute("acc" + i)) {
                if (first) {
                    sb.append('{');
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(i);
            }
            ++i;
        }
        if (!first) {
            sb.append('}');
        }
        sb.append("\"]");
        System.out.println(sb.toString());
    }

    public static void printInit(Node<String> n) {
        System.out.println("\tinit [color=white, label=\"\"];");
        System.out.println("\tinit -> " + n.getId() + ";");
    }

    public static void printNode(Node<String> n) {
        int id = n.getId();
        if (n.getBooleanAttribute("accepting")) {
            System.out.println("\t" + id + " [shape=doublecircle];");
        } else {
            System.out.println("\t" + id + " [shape=circle];");
        }
        String label = n.getStringAttribute("label");
        StringBuilder sb = new StringBuilder();
        sb.append('\t').append(id).append(" [label=\"");
        if (label != null) {
            sb.append(label);
            sb.append("\\n");
        }
        sb.append(id).append("\\n");
        int nsets = n.getGraph().getIntAttribute("nsets");
        boolean first = true;
        int i = 0;
        while (i < nsets) {
            if (n.getBooleanAttribute("acc" + i)) {
                if (first) {
                    sb.append('{');
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(i);
            }
            ++i;
        }
        if (!first) {
            sb.append('}');
        }
        sb.append("\"];");
        System.out.println(sb.toString());
    }

    public static void startDigraph(String name) {
        if (name.lastIndexOf(47) != -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        name = name.replace('.', '_');
        name = name.replace('-', '_');
        System.out.println("digraph " + name + " {");
    }
}

