/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graphio;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Literal;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graphio.FSPWriter;
import gov.nasa.ltl.graphio.SMWriter;
import gov.nasa.ltl.graphio.SpinWriter;
import gov.nasa.ltl.graphio.XMLWriter;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class Writer<PropT> {
    public abstract void write(Graph<PropT> var1);

    public abstract void write(Node<PropT> var1);

    public abstract void write(Edge<PropT> var1);

    public abstract void write(State<PropT>[] var1);

    public abstract void write(State<PropT> var1);

    public abstract void write(Transition<PropT> var1);

    public abstract void write(Guard<PropT> var1);

    public abstract void write(Literal<PropT> var1);

    public static final <PropT> Writer<PropT> getWriter(Format f, PrintStream out) {
        switch (f) {
            case SM: {
                return new SMWriter(out);
            }
            case FSP: {
                return new FSPWriter(out);
            }
            case XML: {
                return new XMLWriter(out);
            }
            case SPIN: {
                return new SpinWriter(out);
            }
        }
        return null;
    }

    public static <PropT> String formatSMGuard(Guard<PropT> g) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(s);
        new SMWriter<PropT>(p).write(g);
        return s.toString();
    }

    public static enum Format {
        SM,
        FSP,
        XML,
        SPIN;

    }
}

