/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;

public class degenSynchronousProduct {
    public static <PropT1, PropT2> void dfs(Graph<PropT1> g, Node<PropT1>[][] nodes, int nsets, Node<PropT1> n0, Node<PropT2> n1) {
        Node<PropT1> n = degenSynchronousProduct.get(g, nodes, n0, n1);
        for (Edge<PropT1> e0 : n0.getOutgoingEdges()) {
            Node<PropT1> next0 = e0.getNext();
            Edge<PropT2> theEdge = null;
            boolean found = false;
            for (Edge<PropT2> e1 : n1.getOutgoingEdges()) {
                if (found) break;
                if (e1.getBooleanAttribute("else")) {
                    if (theEdge == null) {
                        theEdge = e1;
                    }
                } else {
                    found = true;
                    int i = 0;
                    while (i < nsets) {
                        int n1id = n1.getIntAttribute("lower_bound");
                        if (i >= n1id) {
                            boolean b0 = e0.getBooleanAttribute("acc" + i);
                            boolean b1 = e1.getBooleanAttribute("acc" + i);
                            if (b1 && !b0) {
                                found = false;
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (!found) continue;
                theEdge = e1;
            }
            if (theEdge == null) continue;
            Node next1 = theEdge.getNext();
            boolean newNext = degenSynchronousProduct.isNew(nodes, next0, next1);
            Node<PropT1> next = degenSynchronousProduct.get(g, nodes, next0, next1);
            new Edge<PropT1>(n, next, e0.getGuard(), theEdge.getAction(), null);
            if (!newNext) continue;
            degenSynchronousProduct.dfs(g, nodes, nsets, next0, next1);
        }
    }

    public static <PropT1, PropT2> Graph<PropT1> product(Graph<PropT1> g0, Graph<PropT2> g1) {
        int nsets = g0.getIntAttribute("nsets");
        if (nsets != g1.getIntAttribute("nsets")) {
            System.err.println("Different number of accepting sets");
            System.exit(1);
        }
        Graph g = new Graph();
        g.setStringAttribute("type", "ba");
        g.setStringAttribute("ac", "nodes");
        Node[][] nodes = new Node[g0.getNodeCount()][g1.getNodeCount()];
        degenSynchronousProduct.dfs(g, nodes, nsets, g0.getInit(), g1.getInit());
        return g;
    }

    private static <PropT1, PropT2> boolean isNew(Node<PropT1>[][] nodes, Node<PropT1> n0, Node<PropT2> n1) {
        return nodes[n0.getId()][n1.getId()] == null;
    }

    private static <PropT1, PropT2> Node<PropT1> get(Graph<PropT1> g, Node<PropT1>[][] nodes, Node<PropT1> n0, Node<PropT2> n1) {
        if (nodes[n0.getId()][n1.getId()] == null) {
            Node<PropT1> n = new Node<PropT1>(g);
            String label0 = n0.getStringAttribute("label");
            String label1 = n1.getStringAttribute("label");
            if (label0 == null) {
                label0 = Integer.toString(n0.getId());
            }
            if (label1 == null) {
                label1 = Integer.toString(n1.getId());
            }
            n.setStringAttribute("label", String.valueOf(label0) + "+" + label1);
            if (n1.getBooleanAttribute("accepting")) {
                n.setBooleanAttribute("accepting", true);
            }
            Node<PropT1> node = n;
            nodes[n0.getId()][n1.getId()] = node;
            return node;
        }
        return nodes[n0.getId()][n1.getId()];
    }
}

