/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.ColorPair;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.ITypeNeighbor;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.Pair;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

public class SFSReduction {
    /*
     * WARNING - void declaration
     */
    public static <PropT> Graph<PropT> reduce(Graph<PropT> g) {
        Graph<PropT> result;
        int prevNumColors = 1;
        int currNumPO = 3;
        int prevNumPO = 1;
        TreeSet<ColorPair<PropT>> newColorSet = null;
        LinkedList<Pair<ColorPair<PropT>>> newColorList = null;
        boolean accepting = false;
        boolean nonaccepting = false;
        List<Node<PropT>> nodes = g.getNodes();
        for (Node<PropT> currNode : nodes) {
            currNode.setIntAttribute("_prevColor", 1);
            if (SFSReduction.isAccepting(currNode)) {
                currNode.setIntAttribute("_currColor", 1);
                accepting = true;
                continue;
            }
            currNode.setIntAttribute("_currColor", 2);
            nonaccepting = true;
        }
        int currNumColors = accepting && nonaccepting ? 2 : 1;
        boolean[][] currPO = new boolean[2][2];
        int i = 0;
        while (i < 2) {
            int n = 0;
            while (n < 2) {
                currPO[i][n] = i >= n;
                ++n;
            }
            ++i;
        }
        while (currNumColors != prevNumColors || currNumPO != prevNumPO) {
            for (Node<PropT> currNode : nodes) {
                currNode.setIntAttribute("_prevColor", currNode.getIntAttribute("_currColor"));
            }
            boolean[][] prevPO = currPO;
            prevNumColors = currNumColors;
            newColorList = new LinkedList<Pair<ColorPair<PropT>>>();
            newColorSet = new TreeSet<ColorPair<PropT>>();
            for (Node<PropT> currNode : nodes) {
                ColorPair<PropT> colorPair = new ColorPair<PropT>(currNode.getIntAttribute("_prevColor"), SFSReduction.getPrevN(currNode, prevPO));
                newColorList.add(new Pair<ColorPair<PropT>>(currNode.getId(), colorPair));
                newColorSet.add(colorPair);
            }
            currNumColors = newColorSet.size();
            LinkedList ordered = new LinkedList(newColorSet);
            for (Pair pair : newColorList) {
                ColorPair currPair = (ColorPair)pair.getElement();
                g.getNode(pair.getValue()).setIntAttribute("_currColor", ordered.indexOf(currPair) + 1);
            }
            prevNumPO = currNumPO;
            currNumPO = 0;
            currPO = new boolean[currNumColors][currNumColors];
            for (Pair pair : newColorList) {
                ColorPair currPairOne = (ColorPair)pair.getElement();
                for (Pair pair2 : newColorList) {
                    ColorPair currPairTwo = (ColorPair)pair2.getElement();
                    boolean po = prevPO[currPairTwo.getColor() - 1][currPairOne.getColor() - 1];
                    boolean dominate = SFSReduction.iDominateSet(currPairOne.getIMaxSet(), currPairTwo.getIMaxSet(), prevPO);
                    if (po && dominate) {
                        currPO[ordered.indexOf((Object)currPairTwo)][ordered.indexOf((Object)currPairOne)] = true;
                        ++currNumPO;
                        continue;
                    }
                    currPO[ordered.indexOf((Object)currPairTwo)][ordered.indexOf((Object)currPairOne)] = false;
                }
            }
        }
        if (newColorList == null) {
            result = g;
        } else {
            void var14_31;
            result = new Graph();
            Node[] nodeArray = new Node[currNumColors];
            boolean bl = false;
            while (var14_31 < currNumColors) {
                Node<PropT> n;
                nodeArray[var14_31] = n = new Node<PropT>(result);
                ++var14_31;
            }
            for (Pair pair : newColorList) {
                int n = pair.getValue();
                ColorPair colPair = (ColorPair)pair.getElement();
                if (newColorSet == null || !newColorSet.contains(colPair)) continue;
                newColorSet.remove(colPair);
                TreeSet pairSet = colPair.getIMaxSet();
                int color = colPair.getColor();
                Node currNode = nodeArray[color - 1];
                for (ITypeNeighbor neigh : pairSet) {
                    int neighPos = neigh.getColor() - 1;
                    new Edge(currNode, nodeArray[neighPos], neigh.getTransition());
                }
                if (g.getInit().getId() == n) {
                    result.setInit(currNode);
                }
                if (!SFSReduction.isAccepting(g.getNode(n))) continue;
                currNode.setBooleanAttribute("accepting", true);
            }
        }
        return SFSReduction.reachabilityGraph(result);
    }

    private static <PropT> boolean isAccepting(Node<PropT> nodeIn) {
        return nodeIn.getBooleanAttribute("accepting");
    }

    private static <PropT> TreeSet<ITypeNeighbor<PropT>> getPrevN(Node<PropT> currNode, boolean[][] prevPO) {
        ITypeNeighbor<PropT> iNeigh;
        List<Edge<PropT>> edges = currNode.getOutgoingEdges();
        LinkedList<ITypeNeighbor<PropT>> neighbors = new LinkedList<ITypeNeighbor<PropT>>();
        TreeSet<ITypeNeighbor<PropT>> prevN = new TreeSet<ITypeNeighbor<PropT>>();
        for (Edge<PropT> currEdge : edges) {
            iNeigh = new ITypeNeighbor<PropT>(currEdge.getNext().getIntAttribute("_prevColor"), currEdge.getGuard());
            neighbors.add(iNeigh);
        }
        if (neighbors.size() == 0) {
            return prevN;
        }
        do {
            boolean useless = false;
            iNeigh = (ITypeNeighbor<PropT>)neighbors.removeFirst();
            Iterator i = neighbors.iterator();
            while (i.hasNext()) {
                ITypeNeighbor nNeigh = (ITypeNeighbor)i.next();
                ITypeNeighbor<PropT> dominating = SFSReduction.iDominates(iNeigh, nNeigh, prevPO);
                if (dominating == iNeigh) {
                    i.remove();
                }
                if (dominating != nNeigh) continue;
                useless = true;
                break;
            }
            if (useless) continue;
            prevN.add(iNeigh);
        } while (neighbors.size() > 0);
        return prevN;
    }

    private static <PropT> boolean iDominateSet(TreeSet<ITypeNeighbor<PropT>> setOne, TreeSet<ITypeNeighbor<PropT>> setTwo, boolean[][] prevPO) {
        TreeSet<ITypeNeighbor<PropT>> working = new TreeSet<ITypeNeighbor<PropT>>(setTwo);
        block0: for (ITypeNeighbor<PropT> neighTwo : setTwo) {
            for (ITypeNeighbor<PropT> neighOne : setOne) {
                ITypeNeighbor<PropT> dominating = SFSReduction.iDominates(neighOne, neighTwo, prevPO);
                if (dominating != neighOne) continue;
                working.remove(neighTwo);
                continue block0;
            }
        }
        return working.isEmpty();
    }

    private static <PropT> ITypeNeighbor<PropT> iDominates(ITypeNeighbor<PropT> iNeigh, ITypeNeighbor<PropT> nNeigh, boolean[][] prevPO) {
        Guard<PropT> iTerm = iNeigh.getTransition();
        Guard<PropT> nTerm = nNeigh.getTransition();
        int iColor = iNeigh.getColor();
        int nColor = nNeigh.getColor();
        if ((iTerm.subtermOf(nTerm) || iTerm.isTrue()) && prevPO[nColor - 1][iColor - 1]) {
            return iNeigh;
        }
        if ((nTerm.subtermOf(iTerm) || nTerm.isTrue()) && prevPO[iColor - 1][nColor - 1]) {
            return nNeigh;
        }
        return null;
    }

    private static <PropT> Graph<PropT> reachabilityGraph(Graph<PropT> g) {
        Vector work = new Vector();
        Vector<Node> reachable = new Vector<Node>();
        work.add(g.getInit());
        while (!work.isEmpty()) {
            Node currNode = (Node)work.firstElement();
            reachable.add(currNode);
            if (currNode != null) {
                for (Edge currEdge : currNode.getOutgoingEdges()) {
                    Node nextNode = currEdge.getNext();
                    if (work.contains(nextNode) || reachable.contains(nextNode)) continue;
                    work.add(nextNode);
                }
            }
            Node removed = (Node)work.remove(0);
            assert (removed == currNode) : "ERROR";
        }
        if (g.getNodes() != null) {
            for (Node<PropT> n : g.getNodes()) {
                if (reachable.contains(n)) continue;
                g.removeNode(n);
            }
        }
        return g;
    }
}

