/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Pair;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected TokenFactory<?> _factory = CommonTokenFactory.DEFAULT;
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;

    @Override
    public void setTokenFactory(TokenFactory<?> factory) {
        this._factory = factory;
    }

    @Override
    public void beginErrorCondition(Parser recognizer) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser recognizer) {
        return this.errorRecoveryMode;
    }

    @Override
    public void endErrorCondition(Parser recognizer) {
        this.errorRecoveryMode = false;
        this.lastErrorStates = null;
        this.lastErrorIndex = -1;
    }

    @Override
    public void reportError(Parser recognizer, RecognitionException e) throws RecognitionException {
        if (this.errorRecoveryMode) {
            return;
        }
        ++recognizer._syntaxErrors;
        this.beginErrorCondition(recognizer);
        if (e instanceof NoViableAltException) {
            this.reportNoViableAlternative(recognizer, (NoViableAltException)e);
        } else if (e instanceof InputMismatchException) {
            this.reportInputMismatch(recognizer, (InputMismatchException)e);
        } else if (e instanceof FailedPredicateException) {
            this.reportFailedPredicate(recognizer, (FailedPredicateException)e);
        } else {
            System.err.println("unknown recognition error type: " + e.getClass().getName());
            if (recognizer != null) {
                recognizer.notifyErrorListeners(e.getOffendingToken(), e.getMessage(), e);
            }
        }
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        if (this.lastErrorIndex == recognizer.getInputStream().index() && this.lastErrorStates != null && this.lastErrorStates.contains(recognizer.getState())) {
            recognizer.consume();
        }
        this.lastErrorIndex = recognizer.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet(new int[0]);
        }
        this.lastErrorStates.add(recognizer.getState());
        IntervalSet followSet = this.getErrorRecoverySet(recognizer);
        this.consumeUntil(recognizer, followSet);
    }

    @Override
    public void sync(Parser recognizer) {
        ATNState s = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
        if (this.errorRecoveryMode) {
            return;
        }
        TokenStream tokens = recognizer.getInputStream();
        int la = tokens.LA(1);
        if (recognizer.getATN().nextTokens(s).contains(la) || la == -1) {
            return;
        }
        if (recognizer.isExpectedToken(la)) {
            return;
        }
        switch (s.getStateType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(recognizer) != null) {
                    return;
                }
                throw new InputMismatchException(recognizer);
            }
            case 9: 
            case 11: {
                this.reportUnwantedToken(recognizer);
                IntervalSet expecting = recognizer.getExpectedTokens();
                IntervalSet whatFollowsLoopIterationOrRule = expecting.or(this.getErrorRecoverySet(recognizer));
                this.consumeUntil(recognizer, whatFollowsLoopIterationOrRule);
                break;
            }
        }
    }

    public void reportNoViableAlternative(Parser recognizer, NoViableAltException e) throws RecognitionException {
        TokenStream tokens = recognizer.getInputStream();
        String input = tokens instanceof TokenStream ? (e.getStartToken().getType() == -1 ? "<EOF>" : tokens.getText(e.getStartToken(), e.getOffendingToken())) : "<unknown input>";
        String msg = "no viable alternative at input " + this.escapeWSAndQuote(input);
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    public void reportInputMismatch(Parser recognizer, InputMismatchException e) throws RecognitionException {
        String msg = "mismatched input " + this.getTokenErrorDisplay(e.getOffendingToken()) + " expecting " + e.getExpectedTokens().toString(recognizer.getTokenNames());
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    public void reportFailedPredicate(Parser recognizer, FailedPredicateException e) throws RecognitionException {
        String ruleName = recognizer.getRuleNames()[recognizer._ctx.getRuleIndex()];
        String msg = "rule " + ruleName + " " + e.getMessage();
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    public void reportUnwantedToken(Parser recognizer) {
        if (this.errorRecoveryMode) {
            return;
        }
        ++recognizer._syntaxErrors;
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        String tokenName = this.getTokenErrorDisplay(t);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "extraneous input " + tokenName + " expecting " + expecting.toString(recognizer.getTokenNames());
        recognizer.notifyErrorListeners(t, msg, null);
    }

    public void reportMissingToken(Parser recognizer) {
        if (this.errorRecoveryMode) {
            return;
        }
        ++recognizer._syntaxErrors;
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "missing " + expecting.toString(recognizer.getTokenNames()) + " at " + this.getTokenErrorDisplay(t);
        recognizer.notifyErrorListeners(t, msg, null);
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        Token matchedSymbol = this.singleTokenDeletion(recognizer);
        if (matchedSymbol != null) {
            recognizer.consume();
            return matchedSymbol;
        }
        if (this.singleTokenInsertion(recognizer)) {
            return this.getMissingSymbol(recognizer);
        }
        throw new InputMismatchException(recognizer);
    }

    public boolean singleTokenInsertion(Parser recognizer) {
        int currentSymbolType = recognizer.getInputStream().LA(1);
        ATNState currentState = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
        ATN atn = ((ParserATNSimulator)recognizer.getInterpreter()).atn;
        ATNState next = currentState.transition((int)0).target;
        IntervalSet expectingAtLL2 = atn.nextTokens(next, recognizer._ctx);
        if (expectingAtLL2.contains(currentSymbolType)) {
            this.reportMissingToken(recognizer);
            return true;
        }
        return false;
    }

    public Token singleTokenDeletion(Parser recognizer) {
        int nextTokenType = recognizer.getInputStream().LA(2);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        if (expecting.contains(nextTokenType)) {
            this.reportUnwantedToken(recognizer);
            recognizer.consume();
            Token matchedSymbol = recognizer.getCurrentToken();
            this.endErrorCondition(recognizer);
            return matchedSymbol;
        }
        return null;
    }

    protected Token getMissingSymbol(Parser recognizer) {
        Token currentSymbol = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        int expectedTokenType = expecting.getMinElement();
        String tokenText = expectedTokenType == -1 ? "<missing EOF>" : "<missing " + recognizer.getTokenNames()[expectedTokenType] + ">";
        Token current = currentSymbol;
        Token lookback = recognizer.getInputStream().LT(-1);
        if (current.getType() == -1 && lookback != null) {
            current = lookback;
        }
        return this._factory.create(new Pair<TokenSource, CharStream>(current.getTokenSource(), current.getTokenSource().getInputStream()), expectedTokenType, tokenText, 0, -1, -1, current.getLine(), current.getCharPositionInLine());
    }

    public IntervalSet getExpectedTokens(Parser recognizer) {
        return recognizer.getExpectedTokens();
    }

    public String getTokenErrorDisplay(Token t) {
        if (t == null) {
            return "<no token>";
        }
        String s = this.getSymbolText(t);
        if (s == null) {
            s = this.getSymbolType(t) == -1 ? "<EOF>" : "<" + this.getSymbolType(t) + ">";
        }
        return this.escapeWSAndQuote(s);
    }

    protected String getSymbolText(@NotNull Token symbol) {
        return symbol.getText();
    }

    protected int getSymbolType(@NotNull Token symbol) {
        return symbol.getType();
    }

    protected String escapeWSAndQuote(String s) {
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\t", "\\\\t");
        return "'" + s + "'";
    }

    protected IntervalSet getErrorRecoverySet(Parser recognizer) {
        ATN atn = ((ParserATNSimulator)recognizer.getInterpreter()).atn;
        RuleContext ctx = recognizer._ctx;
        IntervalSet recoverSet = new IntervalSet(new int[0]);
        while (ctx != null && ctx.invokingState >= 0) {
            ATNState invokingState = atn.states.get(ctx.invokingState);
            RuleTransition rt = (RuleTransition)invokingState.transition(0);
            IntervalSet follow = atn.nextTokens(rt.followState);
            recoverSet.addAll(follow);
            ctx = ctx.parent;
        }
        recoverSet.remove(-2);
        return recoverSet;
    }

    public void consumeUntil(Parser recognizer, IntervalSet set) {
        int ttype = recognizer.getInputStream().LA(1);
        while (ttype != -1 && !set.contains(ttype)) {
            recognizer.consume();
            ttype = recognizer.getInputStream().LA(1);
        }
    }
}

