/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class XJRollOverButton
extends JButton {
    private boolean inside = false;

    public static XJRollOverButton createTextButton(String text) {
        XJRollOverButton b = new XJRollOverButton(text);
        return b;
    }

    public static XJRollOverButton createSmallButton(ImageIcon icon) {
        XJRollOverButton b = new XJRollOverButton(icon);
        XJRollOverButton.adjustSize(b, 16, 16);
        return b;
    }

    public static XJRollOverButton createMediumButton(ImageIcon icon) {
        XJRollOverButton b = new XJRollOverButton(icon);
        XJRollOverButton.adjustSize(b, 24, 24);
        return b;
    }

    private static void adjustSize(AbstractButton button, int width, int height) {
        Dimension d = new Dimension(width, height);
        button.setMinimumSize(d);
        button.setMaximumSize(d);
        button.setPreferredSize(d);
    }

    protected XJRollOverButton(ImageIcon icon) {
        super(icon);
        this.init();
    }

    protected XJRollOverButton(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.setBorderPainted(false);
        this.setFocusable(false);
        this.setIconTextGap(0);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                XJRollOverButton.this.inside = true;
                XJRollOverButton.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                XJRollOverButton.this.inside = false;
                XJRollOverButton.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        if (this.isEnabled() && this.inside) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.darkGray);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paintComponent(g);
    }
}

