/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.primitive;

import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GDimension
implements SSerializable {
    public String width = "";
    public String up = "";
    public String down = "";
    private float cacheWidth = Float.MIN_VALUE;
    private float cacheUp = Float.MIN_VALUE;
    private float cacheDown = Float.MIN_VALUE;

    public GDimension() {
    }

    public GDimension(GDimension dimension) {
        this.width = dimension.width;
        this.up = dimension.up;
        this.down = dimension.down;
    }

    public GDimension(String width, String up, String down) {
        this.width = width;
        this.up = up;
        this.down = down;
    }

    public void addWidth(String width) {
        this.width = GLiteral.add(this.width, width);
    }

    public void addUp(String up) {
        this.up = GLiteral.add(this.up, up);
    }

    public void addDown(String down) {
        this.down = GLiteral.add(this.down, down);
    }

    public void maxWidth(String width) {
        this.width = GLiteral.max(this.width, width);
    }

    public void maxUp(String height) {
        this.up = GLiteral.max(this.up, height);
    }

    public void maxDown(String height) {
        this.down = GLiteral.max(this.down, height);
    }

    public float getPixelWidth(GContext context) {
        if (this.cacheWidth == Float.MIN_VALUE) {
            return context.getPixelValue(this.width);
        }
        return this.cacheWidth;
    }

    public float getPixelUp(GContext context) {
        if (this.cacheUp == Float.MIN_VALUE) {
            return context.getPixelValue(this.up);
        }
        return this.cacheUp;
    }

    public float getPixelDown(GContext context) {
        if (this.cacheDown == Float.MIN_VALUE) {
            return context.getPixelValue(this.down);
        }
        return this.cacheDown;
    }

    public float getPixelHeight(GContext context) {
        return this.getPixelUp(context) + this.getPixelDown(context);
    }

    public void cache(GContext context) {
        this.cacheWidth = context.getPixelValue(this.width);
        this.cacheUp = context.getPixelValue(this.up);
        this.cacheDown = context.getPixelValue(this.down);
    }

    public String toString() {
        return "{ " + this.width + ", " + this.up + "|" + this.down + " }";
    }

    public void encode(SEncoder encoder) {
        encoder.write(this.width);
        encoder.write(this.up);
        encoder.write(this.down);
    }
}

