/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.awt.Container;
import java.io.File;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.generate.CodeDisplay;
import org.antlr.works.generate.CodeGenerate;
import org.antlr.works.generate.CodeGenerateDelegate;
import org.antlr.works.grammar.CheckGrammar;
import org.antlr.works.grammar.CheckGrammarDelegate;
import org.antlr.works.grammar.antlr.GrammarResult;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

public class GenerateMenu
implements CodeGenerateDelegate,
CheckGrammarDelegate {
    private final GrammarWindow window;
    private String actionShowCodeRule;
    private int actionShowCodeType;
    private boolean actionShowCodeAfterGeneration = false;
    private CodeGenerate codeGenerate;
    private boolean generating = false;

    public GenerateMenu(GrammarWindow window) {
        this.window = window;
    }

    public void awake() {
        this.codeGenerate = new CodeGenerate(this.window, this);
    }

    public void close() {
        this.codeGenerate.close();
    }

    public void generateCode() {
        this.actionShowCodeRule = null;
        this.generateCodeProcess();
    }

    public void showGeneratedCode(int type) {
        StatisticsAW.shared().recordEvent(type == 2 ? 82 : 81);
        this.checkAndShowGeneratedCode(null, type);
    }

    public void showRuleGeneratedCode() {
        StatisticsAW.shared().recordEvent(83);
        if (this.window.getCurrentRule() == null) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "A rule must be selected first.");
        } else {
            ElementRule r = this.window.getCurrentRule();
            this.checkAndShowGeneratedCode(r.name, r.lexer ? 2 : 1);
        }
    }

    private synchronized void generateCodeProcess() {
        if (this.generating) {
            return;
        }
        this.generating = true;
        StatisticsAW.shared().recordEvent(80);
        if (!this.window.ensureDocumentSaved()) {
            return;
        }
        CheckGrammar checkGrammar = new CheckGrammar(this.window, this);
        checkGrammar.check();
    }

    private void generateCodeProcessContinued() {
        if (!this.window.getDocument().autoSave()) {
            this.generating = false;
            return;
        }
        this.codeGenerate.setDebug(false);
        this.codeGenerate.generateInThread((Container)this.window.getJavaContainer());
    }

    private void checkAndShowGeneratedCode(String rule, int type) {
        if (!this.isKnownLanguage()) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "Can only show generated grammar for Java language");
            return;
        }
        if (!this.codeGenerate.isGeneratedTextFileExisting(type) || this.codeGenerate.isFileModifiedSinceLastGeneration() || this.window.getDocument().isDirty()) {
            this.actionShowCodeRule = rule;
            this.actionShowCodeType = type;
            this.actionShowCodeAfterGeneration = true;
            this.generateCodeProcess();
            return;
        }
        this.showGeneratedCode(rule, type);
    }

    private boolean isKnownLanguage() {
        String language = this.codeGenerate.getGrammarLanguage();
        return language != null && language.equals("Java");
    }

    private void showGeneratedCode(String rule, int type) {
        String grammarName;
        try {
            grammarName = this.window.getGrammarEngine().getGeneratedClassName(type);
        }
        catch (Exception e) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "Unable to get the generated class name:\n" + e.toString());
            return;
        }
        String grammarFileName = grammarName + ".java";
        String grammarFile = XJUtils.concatPath(this.codeGenerate.getOutputPath(), grammarFileName);
        if (!new File(grammarFile).exists()) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "The generated code does not exist. It is probably not supported by the grammar.");
            return;
        }
        CodeDisplay cd = new CodeDisplay((XJFrame)this.window);
        cd.setFile(grammarFile);
        cd.setRule(rule);
        cd.load();
        this.window.addTab(cd);
    }

    public boolean codeGenerateDisplaySuccess() {
        return !this.actionShowCodeAfterGeneration;
    }

    public void codeGenerateDidComplete() {
        if (this.actionShowCodeAfterGeneration) {
            this.actionShowCodeAfterGeneration = false;
            this.showGeneratedCode(this.actionShowCodeRule, this.actionShowCodeType);
        }
        this.generating = false;
    }

    public void codeGenerateDidCompleteWithError(String error) {
        this.generating = false;
    }

    public void checkGrammarDidBegin(CheckGrammar source) {
    }

    public void checkGrammarDidEnd(CheckGrammar source, GrammarResult result) {
        if (result.getErrorCount() == 0) {
            this.generateCodeProcessContinued();
        } else {
            this.generating = false;
            XJAlert.display(this.window.getJavaContainer(), "Error", "Check Grammar reported some errors:\n" + result.getFirstErrorMessage() + "\nConsult the console for more information.");
        }
        source.close();
    }
}

