/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.interpreter;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.tool.Grammar;
import org.antlr.works.utils.awtree.AWTreeNode;

public class EditorInterpreterTreeModel
extends DefaultTreeModel {
    protected Grammar grammar;

    public EditorInterpreterTreeModel() {
        super(null);
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public void setTree(Tree tree) {
        this.setRoot(new InterpreterTreeNode(null, tree));
    }

    public class InterpreterTreeNode
    extends AWTreeNode {
        protected Tree tree;

        public InterpreterTreeNode(TreeNode parent, Tree tree) {
            this.parent = (MutableTreeNode)parent;
            this.tree = tree;
        }

        public TreeNode getChildAt(int childIndex) {
            return new InterpreterTreeNode(this, this.tree.getChild(childIndex));
        }

        public int getChildCount() {
            return this.tree.getChildCount();
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.tree.getChildCount(); ++i) {
                if (this.tree.getChild(i) != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public Enumeration children() {
            return null;
        }

        public Object getPayload() {
            if (this.tree instanceof ParseTree) {
                return ((ParseTree)this.tree).payload;
            }
            return null;
        }

        public Color getColor() {
            return Color.black;
        }

        public String getInfoString() {
            StringBuilder info = new StringBuilder();
            Object payload = this.getPayload();
            if (payload instanceof CommonToken) {
                CommonToken t = (CommonToken)payload;
                info.append("Type: ").append(EditorInterpreterTreeModel.this.grammar.getTokenDisplayName(t.getType())).append("\n");
                info.append("Text: ").append(t.getText()).append("\n");
                info.append("Line: ").append(t.getLine()).append("\n");
                info.append("Char: ").append(t.getCharPositionInLine()).append("\n");
                info.append("Channel: ").append(t.getChannel()).append("\n");
            } else if (payload instanceof NoViableAltException) {
                NoViableAltException e = (NoViableAltException)payload;
                info.append("Description: ").append(e.grammarDecisionDescription).append("\n");
                info.append("Descision: ").append(e.decisionNumber).append("\n");
                info.append("State: ").append(e.stateNumber).append("\n");
            } else if (this.isLeaf()) {
                info.append(payload.toString());
            } else {
                info.append("Rule: ").append(payload.toString());
            }
            return info.toString();
        }

        public String toString() {
            Object payload = this.getPayload();
            if (payload instanceof CommonToken) {
                CommonToken t = (CommonToken)payload;
                return t.getText();
            }
            if (payload instanceof NoViableAltException) {
                return "NoViableAltException";
            }
            if (payload == null) {
                return "<null>";
            }
            return payload.toString();
        }
    }
}

