/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.editor.tips.TipsManager;
import org.antlr.works.editor.tips.TipsOverlay;
import org.antlr.works.editor.tips.TipsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTips
implements TipsProvider {
    public TipsManager tipsManager;
    public GrammarWindow window;

    public EditorTips(GrammarWindow window) {
        this.window = window;
    }

    public void awake() {
        this.tipsManager = new TipsManager();
        this.tipsManager.setOverlay(new TipsOverlay(this.window, this.window.getTextPane()));
        this.tipsManager.addProvider(this);
    }

    public void toggleEnabled() {
        this.tipsManager.setEnabled(!this.tipsManager.enabled());
    }

    public void hide() {
        this.tipsManager.hide();
    }

    public void close() {
        this.window = null;
        this.tipsManager.close();
    }

    public void display(Point relativePoint, Point absolutePoint) {
        if (this.window.getTokens() == null) {
            return;
        }
        int position = this.window.getTextPane().viewToModel(relativePoint);
        Point p = null;
        try {
            Rectangle r2;
            Rectangle r1;
            ATEToken token = this.window.getTokenAtPosition(position, false);
            if (token != null && (r1 = this.window.getTextPane().modelToView(token.getStartIndex())).union(r2 = this.window.getTextPane().modelToView(token.getEndIndex())).contains(relativePoint)) {
                p = SwingUtilities.convertPoint(this.window.getTextPane(), new Point(relativePoint.x + 2, r2.y - 5), this.window.getJavaContainer());
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        this.tipsManager.displayAnyTipsAvailable(position, p);
    }

    @Override
    public List<String> tipsProviderGetTips(int position) {
        ArrayList<String> tips = new ArrayList<String>();
        List<EditorInspectorItem> items = this.window.editorInspector.getAllItemsAtIndex(position);
        for (EditorInspectorItem item : items) {
            tips.add(item.description);
        }
        return tips;
    }
}

