/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tree;

import java.awt.Component;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.tree.DBParseTreeModel;
import org.antlr.works.debugger.tree.DBParseTreeModelListener;
import org.antlr.works.debugger.tree.DBTreeNode;
import org.antlr.works.utils.DetachablePanel;
import org.antlr.works.utils.awtree.AWTreePanel;
import org.antlr.works.utils.awtree.AWTreePanelDelegate;
import org.antlr.xjlib.appkit.gview.GView;

public class DBParseTreePanel
extends DetachablePanel
implements DBParseTreeModelListener,
AWTreePanelDelegate {
    protected DebuggerTab debuggerTab;
    protected DBParseTreeModel model;
    protected AWTreePanel treePanel;

    public DBParseTreePanel(DebuggerTab debuggerTab) {
        super("Parse Tree", debuggerTab);
        this.debuggerTab = debuggerTab;
        this.model = new DBParseTreeModel(debuggerTab);
        this.model.addListener(this);
        this.treePanel = new AWTreePanel(new DefaultTreeModel(null));
        this.treePanel.setDelegate(this);
        this.mainPanel.add((Component)this.treePanel, "Center");
    }

    public void close() {
        super.close();
        this.treePanel.setDelegate(null);
        this.model.close();
        this.model = null;
        this.debuggerTab = null;
    }

    public DBParseTreeModel getModel() {
        return this.model;
    }

    public void clear() {
        this.model.clear();
        this.treePanel.clear();
    }

    public void updateOnBreakEvent() {
        this.model.fireDataChanged();
    }

    public void selectToken(Token token) {
        DBTreeNode root = (DBTreeNode)this.treePanel.getRoot();
        DBTreeNode node = root.findNodeWithToken(token);
        if (node != null) {
            this.treePanel.selectNode(node);
        }
    }

    public void updateParseTree() {
        this.treePanel.refresh();
        this.treePanel.scrollNodeToVisible(this.model.getLastNode());
    }

    public GView getGraphView() {
        return this.treePanel.getGraphView();
    }

    public void modelChanged(DBParseTreeModel model) {
        this.treePanel.setRoot(model.getRootRule());
        this.updateParseTree();
    }

    public void modelUpdated(DBParseTreeModel model) {
        this.updateParseTree();
    }

    public void awTreeDidSelectTreeNode(TreeNode node, boolean shiftKey) {
        DBTreeNode n = (DBTreeNode)node;
        this.debuggerTab.selectToken(n.token, n.getLocation());
    }

    public JPopupMenu awTreeGetContextualMenu() {
        return this.debuggerTab.treeGetContextualMenu();
    }
}

