/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.panels;

import java.awt.Component;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.panels.DBInputConcretePanel;
import org.antlr.works.debugger.panels.DBInputTokenPanel;
import org.antlr.works.debugger.panels.DBInputTreePanel;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.utils.DetachablePanel;

public class DBInputPanel
extends DetachablePanel {
    protected DebuggerTab debuggerTab;
    protected DBInputTokenPanel inputTokenPanel;
    protected DBInputTreePanel inputTreePanel;
    protected DBInputConcretePanel currentPanel;

    public DBInputPanel(DebuggerTab debuggerTab) {
        super("Input", debuggerTab);
        this.debuggerTab = debuggerTab;
        this.inputTokenPanel = new DBInputTokenPanel(debuggerTab);
        this.inputTreePanel = new DBInputTreePanel(debuggerTab);
        this.setCurrentPanel(this.inputTokenPanel);
    }

    public void setCurrentPanel(DBInputConcretePanel panel) {
        this.currentPanel = panel;
        if (this.mainPanel.getComponentCount() > 0) {
            this.mainPanel.remove(0);
        }
        this.mainPanel.add((Component)this.currentPanel.getComponent(), "Center");
    }

    public void prepareForGrammar(GrammarEngine engineGrammar) {
        if (engineGrammar.isTreeParserGrammar()) {
            this.setCurrentPanel(this.inputTreePanel);
        } else {
            this.setCurrentPanel(this.inputTokenPanel);
        }
    }

    public void close() {
        super.close();
        this.inputTokenPanel.close();
        this.inputTreePanel.close();
        this.debuggerTab = null;
        this.currentPanel.close();
    }

    public DBInputProcessor getInputBuffer() {
        return this.currentPanel.getInputProcessor();
    }

    public void toggleInputTokensBox() {
        this.currentPanel.toggleInputTextTokensBox();
    }

    public boolean isInputTokensBoxVisible() {
        return this.currentPanel.isInputTokensBoxVisible();
    }

    public void updateOnBreakEvent() {
        this.currentPanel.updateOnBreakEvent();
    }

    public boolean isBreakpointAtToken(Token token) {
        return this.currentPanel.isBreakpointAtToken(token);
    }

    public void stop() {
        this.currentPanel.stop();
    }

    public void selectToken(Token token) {
        this.currentPanel.selectToken(token);
    }

    public DBInputTextTokenInfo getTokenInfoForToken(Token token) {
        return this.currentPanel.getTokenInfoForToken(token);
    }
}

