/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Power
extends PostfixMathCommand {
    public Power() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.power(param1, param2));
    }

    public Object power(Object param1, Object param2) throws ParseException {
        if (param1 == NULL._null) {
            param1 = new Integer(0);
        }
        if (param2 == NULL._null) {
            param2 = new Integer(0);
        }
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.power((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.power((Number)param1, (Complex)param2);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.power((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.power((Complex)param1, (Complex)param2);
            }
        } else if (param1 instanceof TypeObject && param2 instanceof TypeObject) {
            return this.power(((TypeObject)param1).getMathValueTyped(), ((TypeObject)param2).getMathValueTyped());
        }
        throw new ParseException("Invalid parameter type");
    }

    public Object power(Number d1, Number d2) {
        if (d1.doubleValue() < 0.0 && d2.doubleValue() != (double)d2.intValue()) {
            Complex c = new Complex(d1.doubleValue(), 0.0);
            return c.power(d2.doubleValue());
        }
        return new Double(Math.pow(d1.doubleValue(), d2.doubleValue()));
    }

    public Object power(Complex c1, Complex c2) {
        Complex temp = c1.power(c2);
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }

    public Object power(Complex c, Number d) {
        Complex temp = c.power(d.doubleValue());
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }

    public Object power(Number d, Complex c) {
        Complex base = new Complex(d.doubleValue(), 0.0);
        Complex temp = base.power(c);
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }
}

