/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.function.FastFailable;
import org.nfunk.jep.function.PostfixMathCommand;

public class Logical
extends PostfixMathCommand
implements FastFailable {
    int id;
    public static final Double _false = new Double(0.0);
    public static final Double _true = new Double(1.0);

    public Logical(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
    }

    public boolean isAnd() {
        return this.id == 0;
    }

    public boolean isFastFailable() {
        return true;
    }

    public void run(Stack inStack) throws ParseException {
        boolean r;
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        if (param1 instanceof Boolean) {
            Double d = param1 = (Boolean)param1 != false ? _true : _false;
        }
        if (param2 instanceof Boolean) {
            Double d = param2 = (Boolean)param2 != false ? _true : _false;
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double x = ((Number)param1).doubleValue();
            double y = ((Number)param2).doubleValue();
            switch (this.id) {
                case 0: {
                    r = x != 0.0 && y != 0.0;
                    break;
                }
                case 1: {
                    r = x != 0.0 || y != 0.0;
                    break;
                }
                default: {
                    r = false;
                }
            }
        } else {
            throw new ParseException("Invalid parameter type: " + param1 + " Multiply " + param2);
        }
        inStack.push(new Double((double)r));
    }

    public Object childrenFastFailAccept(Node[] children, Stack theStack, ParserVisitor visitor, Object data) {
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].jjtAccept(visitor, data);
                Object lastEvalResult = theStack.peek();
                if (++i >= children.length) continue;
                boolean isTrue = false;
                if (lastEvalResult instanceof Boolean) {
                    isTrue = (Boolean)theStack.peek();
                } else if (lastEvalResult instanceof Double) {
                    boolean bl = isTrue = (Double)theStack.peek() > 0.0;
                }
                if (this.isAnd()) {
                    if (isTrue) continue;
                    while (i < children.length) {
                        theStack.push(_false);
                        ++i;
                    }
                    continue;
                }
                if (!isTrue) continue;
                while (i < children.length) {
                    theStack.push(_true);
                    ++i;
                }
            }
        }
        return data;
    }
}

