/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Divide
extends PostfixMathCommand {
    public Divide() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.div(param1, param2));
    }

    public Object div(Object param1, Object param2) throws ParseException {
        if (param1 == NULL._null) {
            param1 = new Integer(0);
        }
        if (param2 == NULL._null) {
            param2 = new Integer(0);
        }
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.div((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Number)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Number)param1, (Vector)param2);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.div((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Vector) {
                return this.div((Complex)param1, (Vector)param2);
            }
        } else if (param1 instanceof Vector) {
            if (param2 instanceof Number) {
                return this.div((Vector)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.div((Vector)param1, (Complex)param2);
            }
        }
        throw new ParseException("Invalid parameter type: " + param1 + " Divide " + param2);
    }

    public Double div(Number d1, Number d2) {
        return new Double(d1.doubleValue() / d2.doubleValue());
    }

    public Complex div(Complex c1, Complex c2) {
        return c1.div(c2);
    }

    public Complex div(Number d, Complex c) {
        Complex c1 = new Complex(d.doubleValue(), 0.0);
        return c1.div(c);
    }

    public Complex div(Complex c, Number d) {
        return new Complex(c.re() / d.doubleValue(), c.im() / d.doubleValue());
    }

    public Vector div(Vector v, Number d) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div((Number)v.elementAt(i), d));
        }
        return result;
    }

    public Vector div(Number d, Vector v) {
        Vector<Double> result = new Vector<Double>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div(d, (Number)v.elementAt(i)));
        }
        return result;
    }

    public Vector div(Vector v, Complex c) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div((Number)v.elementAt(i), c));
        }
        return result;
    }

    public Vector div(Complex c, Vector v) {
        Vector<Complex> result = new Vector<Complex>();
        for (int i = 0; i < v.size(); ++i) {
            result.addElement(this.div(c, (Number)v.elementAt(i)));
        }
        return result;
    }
}

