/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Comparative
extends PostfixMathCommand {
    public final int COMPARATIVE_LESS = 0;
    public final int COMPARATIVE_GREATER = 1;
    public final int COMPARATIVE_LESS_EQUAL = 2;
    public final int COMPARATIVE_GREATER_EQUAL = 3;
    public final int COMPARATIVE_NOT_EQUAL = 4;
    public final int COMPARATIVE_EQUAL = 5;
    public static final Double _false = new Double(0.0);
    public static final Double _true = new Double(1.0);
    public static final double _pFalse = _false;
    public static final double _pTrue = _true;
    public static final String[] COMPARATIVES = new String[]{"Less", "Greater", "LessEqual", "GreaterEqual", "NotEqual", "Equal"};
    int id;
    double tolerance;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        if (param1 instanceof TypeObject) {
            param1 = ((TypeObject)param1).getMathValueTyped();
        }
        if (param2 instanceof TypeObject) {
            param2 = ((TypeObject)param2).getMathValueTyped();
        }
        this.compare(inStack, param2, param1);
    }

    private void compare(Stack inStack, Object param2, Object param1) throws ParseException {
        boolean par1IsNum = param1 instanceof Number;
        boolean par2IsNum = param2 instanceof Number;
        if (par1IsNum || par2IsNum) {
            double r;
            boolean par1IsString = param1 instanceof String;
            boolean par2IsString = param2 instanceof String;
            double x = 0.0;
            if (par1IsNum) {
                x = ((Number)param1).doubleValue();
            } else if (par1IsString) {
                x = param1.toString().length() == 0 ? 0.0 : Double.parseDouble(param1.toString());
            } else if (param1 instanceof Boolean) {
                x = (Boolean)param1 != false ? 1 : 0;
            }
            double y = 0.0;
            if (par2IsNum) {
                y = ((Number)param2).doubleValue();
            } else if (par2IsString) {
                y = param2.toString().length() == 0 ? 0.0 : Double.parseDouble(param2.toString());
            } else if (param2 instanceof Boolean) {
                y = (Boolean)param2 != false ? 1 : 0;
            }
            switch (this.id) {
                case 0: {
                    r = x < y ? _pTrue : _pFalse;
                    break;
                }
                case 1: {
                    r = x > y ? _pTrue : _pFalse;
                    break;
                }
                case 2: {
                    r = x <= y ? _pTrue : _pFalse;
                    break;
                }
                case 3: {
                    r = x >= y ? _pTrue : _pFalse;
                    break;
                }
                case 4: {
                    r = x != y ? _pTrue : _pFalse;
                    break;
                }
                case 5: {
                    r = x == y ? _pTrue : _pFalse;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator:" + this.id);
                }
            }
            inStack.push(new Double(r));
        } else if (param1 instanceof String && param2 instanceof String) {
            double r;
            switch (this.id) {
                case 4: {
                    r = param1.equals(param2) ? _pFalse : _pTrue;
                    break;
                }
                case 5: {
                    r = param1.equals(param2) ? _pTrue : _pFalse;
                    break;
                }
                case 1: {
                    r = ((String)param1).compareTo((String)param2) > 0 ? _pTrue : _pFalse;
                    break;
                }
                case 0: {
                    r = ((String)param1).compareTo((String)param2) < 0 ? _pTrue : _pFalse;
                    break;
                }
                case 3: {
                    r = ((String)param1).compareTo((String)param2) >= 0 ? _pTrue : _pFalse;
                    break;
                }
                case 2: {
                    r = ((String)param1).compareTo((String)param2) <= 0 ? _pTrue : _pFalse;
                    break;
                }
                default: {
                    if (this.id >= 0 && this.id < COMPARATIVES.length) {
                        throw new ParseException("Relational operator type error:" + COMPARATIVES[this.id]);
                    }
                    throw new ParseException("Relational operator type error:");
                }
            }
            inStack.push(new Double(r));
        } else if (param1 instanceof Complex && param2 instanceof Complex) {
            double r;
            switch (this.id) {
                case 4: {
                    r = ((Complex)param1).equals((Complex)param2, this.tolerance) ? _pFalse : _pTrue;
                    break;
                }
                case 5: {
                    r = ((Complex)param1).equals((Complex)param2, this.tolerance) ? _pTrue : _pFalse;
                    break;
                }
                default: {
                    if (this.id >= 0 && this.id < COMPARATIVES.length) {
                        throw new ParseException("Relational operator type error:" + COMPARATIVES[this.id]);
                    }
                    throw new ParseException("Relational operator type error:");
                }
            }
            inStack.push(new Double(r));
        } else {
            double r;
            if (param1 instanceof Boolean) {
                param1 = new Double((Boolean)param1 != false ? _pTrue : _pFalse);
            }
            if (param2 instanceof Boolean) {
                param2 = new Double((Boolean)param2 != false ? _pTrue : _pFalse);
            }
            switch (this.id) {
                case 4: {
                    r = param1.equals(param2) ? _pFalse : _pTrue;
                    break;
                }
                case 5: {
                    r = param1.equals(param2) ? _pTrue : _pFalse;
                    break;
                }
                case 1: 
                case 3: {
                    if (param1 == null && param2 == null) {
                        r = 1.0;
                        break;
                    }
                    r = param2 == NULL._null ? _pTrue : _pFalse;
                    break;
                }
                case 0: 
                case 2: {
                    if (param1 == null && param2 == null) {
                        r = 1.0;
                        break;
                    }
                    if (param1 == param2) {
                        r = 1.0;
                        break;
                    }
                    r = param2 == NULL._null ? _pFalse : _pTrue;
                    break;
                }
                default: {
                    if (this.id >= 0 && this.id < COMPARATIVES.length) {
                        throw new ParseException("Relational operator type error: " + param1 + " " + COMPARATIVES[this.id] + " " + param2);
                    }
                    throw new ParseException("Relational operator type error:");
                }
            }
            inStack.push(new Double(r));
        }
    }
}

