/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.xpath.ResetableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TypeIterator2
extends ResetableIterator {
    private boolean _listTypeIncluded = true;
    private boolean _idOnly = false;
    private boolean _editingTypeIncluded = true;
    private boolean _editingTypeTraversalOnly = false;
    private boolean _onlySerializable = false;
    private boolean _buildLazyChoices = false;

    public TypeIterator2(Type contextType, boolean listTypeIncluded, boolean editingTypeIncluded, boolean editingTypeTraversalOnly, boolean choosenTypeOnly, boolean buildLazyChoices) {
        this(contextType, listTypeIncluded, editingTypeIncluded, editingTypeTraversalOnly, choosenTypeOnly, buildLazyChoices, false);
    }

    public TypeIterator2(Type contextType, boolean listTypeIncluded, boolean editingTypeIncluded, boolean editingTypeTraversalOnly, boolean choosenTypeOnly, boolean buildLazyChoices, boolean idOnly) {
        this._editingTypeTraversalOnly = editingTypeTraversalOnly;
        this._listTypeIncluded = listTypeIncluded;
        this._idOnly = idOnly;
        this._editingTypeIncluded = editingTypeIncluded;
        this._onlySerializable = choosenTypeOnly;
        this._buildLazyChoices = buildLazyChoices;
        if (contextType != null) {
            this.initChilds(contextType);
        }
    }

    public boolean hasNext() {
        while (!this.isXPathNode((Type)this.getCurrent())) {
            super.next();
        }
        return super.hasNext();
    }

    private void initChilds(Type aType) {
        if (this._buildLazyChoices && aType.isChoice()) {
            ((CompositeType)aType).createChoices();
        }
        List directChilds = this.getDirectChildren(aType);
        for (int i = 0; i < directChilds.size(); ++i) {
            Type aChildType = (Type)directChilds.get(i);
            if (this._idOnly && aChildType.getSchemaElement().getSchemaType().isSimple()) {
                if (!((SchemaSimpleType)aChildType.getSchemaElement().getSchemaType()).isID()) continue;
                this.addChild(aChildType);
                continue;
            }
            if (!this._editingTypeIncluded && aChildType.isAttribute()) continue;
            if (aChildType.isList()) {
                if (!this._editingTypeTraversalOnly) {
                    Iterator listEntries = ((ListType)aChildType).getDirectChildren().iterator();
                    Type listEntry = null;
                    while (listEntries.hasNext()) {
                        listEntry = (Type)listEntries.next();
                        if (this._onlySerializable) {
                            if (!listEntry.isSerializable()) continue;
                            this.addChild(listEntry);
                            continue;
                        }
                        this.addChild(listEntry);
                    }
                    if (this._listTypeIncluded) {
                        this.addChild(aChildType);
                    }
                }
                if (!this._editingTypeIncluded) continue;
                Type editingType = ((ListType)aChildType).getEditingType();
                this.addChild(editingType);
                continue;
            }
            if (this._onlySerializable) {
                if (!aChildType.isSerializable()) continue;
                this.addChild(aChildType);
                continue;
            }
            this.addChild(aChildType);
        }
    }

    public void reset() {
        super.reset();
    }

    private boolean isXPathNode(Type node) {
        if (node == null) {
            return true;
        }
        if (node.isAttribute()) {
            return true;
        }
        if (node.isSimple()) {
            return true;
        }
        if (node.isComposite()) {
            return true;
        }
        return node.isList();
    }

    private List getDirectChildren(Type aType) {
        Vector children = aType.getDirectChildren();
        if (aType.isAbstract()) {
            children = new Vector();
            if (aType.getChoosenType() != null) {
                children.addAll(aType.getChoosenType().getDirectChildren());
            }
        }
        return children;
    }
}

