/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEdit;
import java.io.PrintWriter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public abstract class JAXFrontUndoableEditWrapper
implements JAXFrontUndoableEdit {
    protected boolean dead = false;
    protected boolean _significant = true;
    protected boolean _isInCompoundEdit = false;
    protected Object _sourceType = null;
    protected Document _targetDOM = null;
    protected String _targetTypeXPath = null;
    protected String _relativeTargetTypeXPath = null;
    protected String _action = null;
    protected String _undoName;
    protected String _redoName;
    protected JAXFrontUndoManager _manager = null;
    boolean wasRuleEngineBlocked = false;
    protected boolean _isLast;
    protected boolean _isFirst;

    public JAXFrontUndoableEditWrapper(JAXFrontUndoManager manager, Type targetType) {
        this._manager = manager;
        this._targetTypeXPath = targetType.getXPathLocation();
        this._relativeTargetTypeXPath = DOMHelper.getRelativeXPathLocation(targetType);
        this._targetDOM = targetType.getDOM();
        this._undoName = this._redoName = targetType.getStyle().getLabelText();
    }

    public JAXFrontUndoableEditWrapper(JAXFrontUndoManager manager, String targetTypeXPath) {
        this._manager = manager;
        this._targetTypeXPath = targetTypeXPath;
        this._targetDOM = manager._dom;
        this._redoName = "";
        this._undoName = "";
    }

    public boolean canRedo() {
        return !this.dead;
    }

    public boolean canUndo() {
        return !this.dead;
    }

    public void die() {
        this.dead = true;
    }

    public void undo() throws CannotUndoException {
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "undo:" + this._targetTypeXPath);
        }
    }

    public void redo() throws CannotRedoException {
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "redo:" + this._targetTypeXPath);
        }
    }

    public void macroUndo() throws CannotUndoException {
        this.undo();
    }

    public void macroRedo() {
        this.redo();
    }

    public boolean isSignificant() {
        return this._significant;
    }

    public void setSignificant(boolean significant) {
        this._significant = significant;
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    public String getRedoPresentationName() {
        return this._redoName;
    }

    public String getUndoPresentationName() {
        return this._undoName;
    }

    public void serialize(PrintWriter writer) {
        if (this._action != null) {
            writer.print("<action>");
            writer.print(this._action);
            writer.print("</action>");
        }
        if (this._targetTypeXPath != null) {
            writer.print("<targetType>");
            writer.print(this._targetTypeXPath);
            writer.print("</targetType>");
        }
        if (this._sourceType != null) {
            writer.print("<sourceType>");
            writer.print(this._sourceType.getClass().getName());
            writer.print("</sourceType>");
        }
    }

    public void startBlocking() {
        if (this._targetDOM != null && this._targetDOM.isRuleEngineBlocked()) {
            this._targetDOM.setRuleEngineBlocked(true);
        }
    }

    public void stopBlocking() {
        if (this._targetDOM != null && !this.wasRuleEngineBlocked) {
            this._targetDOM.setRuleEngineBlocked(false);
        }
    }

    public void setIsInCompoundEdit(boolean inCompoundEdit) {
        this._isInCompoundEdit = inCompoundEdit;
    }

    public void visualizeUndo(Type type) {
        if (this._isInCompoundEdit) {
            if (this._isFirst) {
                IntroSpectionHelper.callFunktion("com.jaxfront.swing.ui.tools.FocusHelper", new Class[]{}, new Object[]{}, "focus", new Class[]{Type.class}, new Object[]{type});
            }
        } else {
            IntroSpectionHelper.callFunktion("com.jaxfront.swing.ui.tools.FocusHelper", new Class[]{}, new Object[]{}, "focus", new Class[]{Type.class}, new Object[]{type});
        }
    }

    public void visualizeRedo(Type type) {
        if (this._isInCompoundEdit) {
            if (this._isLast) {
                IntroSpectionHelper.callFunktion("com.jaxfront.swing.ui.tools.FocusHelper", new Class[]{}, new Object[]{}, "focus", new Class[]{Type.class}, new Object[]{type});
            }
        } else {
            IntroSpectionHelper.callFunktion("com.jaxfront.swing.ui.tools.FocusHelper", new Class[]{}, new Object[]{}, "focus", new Class[]{Type.class}, new Object[]{type});
        }
    }

    public void setLast(boolean isLast) {
        this._isLast = isLast;
    }

    public void setFirst(boolean isFirst) {
        this._isFirst = isFirst;
    }

    public Type evalTargetType() {
        Type tt = TypePathExecuter.getInstance().getTypeForXPath(this._targetDOM.getRootType(), this._targetTypeXPath);
        if (tt == null && LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().error(this.getClass(), "can't find undo target:" + this._targetTypeXPath);
        }
        return tt;
    }

    public String getInfo() {
        return this.getClass().getName();
    }
}

